/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataMap;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.logging.Logging;
import org.opengis.annotation.UML;

final class DescriptionMap
extends MetadataMap<String>
implements Localized {
    private final ResourceBundle descriptions;
    final String classname;
    private int size = -1;

    DescriptionMap(PropertyAccessor propertyAccessor, String string, Locale locale, KeyNamePolicy keyNamePolicy) throws MissingResourceException {
        super(propertyAccessor, keyNamePolicy);
        Class<?> clazz = propertyAccessor.type;
        UML uML = clazz.getAnnotation(UML.class);
        this.classname = uML != null ? uML.identifier() : clazz.getSimpleName();
        this.descriptions = ResourceBundle.getBundle(string + "Descriptions", locale);
    }

    public Locale getLocale() {
        return this.descriptions.getLocale();
    }

    @Override
    public boolean isEmpty() {
        if (this.size < 0) {
            if (this.getString(this.classname) != null) {
                return false;
            }
            int n = this.accessor.count();
            for (int i = 0; i < n; ++i) {
                if (this.getString(this.key(i)) == null) continue;
                return false;
            }
            this.size = 0;
        }
        return this.size == 0;
    }

    @Override
    public int size() {
        if (this.size < 0) {
            int n = 0;
            if (this.getString(this.classname) != null) {
                ++n;
            }
            int n2 = this.accessor.count();
            for (int i = 0; i < n2; ++i) {
                if (this.getString(this.key(i)) == null) continue;
                ++n;
            }
            this.size = n;
        }
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    final String key(int n) {
        String string = this.classname;
        Class<?> clazz = this.accessor.getDeclaringClass(n);
        if (clazz != null) {
            UML uML = clazz.getAnnotation(UML.class);
            string = uML != null ? uML.identifier() : clazz.getSimpleName();
        }
        return string + '.' + this.accessor.name(n, KeyNamePolicy.UML_IDENTIFIER);
    }

    final String getString(String string) {
        try {
            return this.descriptions.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Logging.recoverableException(DescriptionMap.class, (String)"get", (Throwable)missingResourceException);
            return null;
        }
    }

    @Override
    public String get(Object object) {
        if (object instanceof String) {
            if (((String)object).equalsIgnoreCase("class")) {
                return this.getString(this.classname);
            }
            int n = this.accessor.indexOf((String)object);
            if (n >= 0) {
                return this.getString(this.key(n));
            }
        }
        return null;
    }

    @Override
    final Iterator<Map.Entry<String, String>> iterator() {
        return new Iter();
    }

    private final class Iter
    extends MetadataMap.Iter {
        private String nextDescription;
        private int nextIndex = -1;

        Iter() {
            this.nextDescription = DescriptionMap.this.getString(DescriptionMap.this.classname);
            if (this.nextDescription == null) {
                this.move();
            }
        }

        private void move() {
            while (++this.nextIndex < DescriptionMap.this.accessor.count()) {
                this.nextDescription = DescriptionMap.this.getString(DescriptionMap.this.key(this.nextIndex));
                if (this.nextDescription == null) continue;
                return;
            }
            this.nextDescription = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextDescription != null;
        }

        @Override
        public Map.Entry<String, String> next() {
            String string = this.nextDescription;
            if (string == null) {
                throw new NoSuchElementException();
            }
            String string2 = this.nextIndex >= 0 ? DescriptionMap.this.accessor.name(this.nextIndex, DescriptionMap.this.keyNames) : "class";
            this.move();
            return new AbstractMap.SimpleEntry<String, String>(string2, string);
        }
    }
}

