/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotoolkit.geometry.jts.transform.GeometryTransformer;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGeometryTransformer
implements GeometryTransformer {
    protected final GeometryFactory gf;
    protected final CoordinateSequenceFactory csf;

    public AbstractGeometryTransformer() {
        this((CoordinateSequenceFactory)null);
    }

    public AbstractGeometryTransformer(CoordinateSequenceFactory csf) {
        if (csf == null) {
            this.gf = new GeometryFactory();
            this.csf = this.gf.getCoordinateSequenceFactory();
        } else {
            this.csf = csf;
            this.gf = new GeometryFactory(csf);
        }
    }

    public AbstractGeometryTransformer(GeometryFactory gf) {
        if (gf == null) {
            this.gf = new GeometryFactory();
            this.csf = gf.getCoordinateSequenceFactory();
        } else {
            this.csf = gf.getCoordinateSequenceFactory();
            this.gf = gf;
        }
    }

    @Override
    public Geometry transform(Geometry geom) throws TransformException {
        if (geom instanceof Point) {
            return this.transform((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.transform((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return this.transform((LineString)geom);
        }
        if (geom instanceof LinearRing) {
            return this.transform((LinearRing)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.transform((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.transform((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return this.transform((MultiPolygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.transform((GeometryCollection)geom);
        }
        throw new IllegalArgumentException("Geometry type is unknowed or null : " + geom);
    }

    protected Point transform(Point geom) throws TransformException {
        CoordinateSequence coord = geom.getCoordinateSequence();
        return this.gf.createPoint(this.transform(coord, 1));
    }

    protected MultiPoint transform(MultiPoint geom) throws TransformException {
        int nbGeom = geom.getNumGeometries();
        Point[] subs = new Point[geom.getNumGeometries()];
        for (int i = 0; i < nbGeom; ++i) {
            subs[i] = this.transform((Point)geom.getGeometryN(i));
        }
        return this.gf.createMultiPoint(subs);
    }

    protected LineString transform(LineString geom) throws TransformException {
        CoordinateSequence seq = this.transform(geom.getCoordinateSequence(), 2);
        return this.gf.createLineString(seq);
    }

    protected LinearRing transform(LinearRing geom) throws TransformException {
        CoordinateSequence seq = this.transform(geom.getCoordinateSequence(), 4);
        return this.gf.createLinearRing(seq);
    }

    protected MultiLineString transform(MultiLineString geom) throws TransformException {
        LineString[] subs = new LineString[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform((LineString)geom.getGeometryN(i));
        }
        return this.gf.createMultiLineString(subs);
    }

    protected Polygon transform(Polygon geom) throws TransformException {
        LinearRing exterior = this.transform((LinearRing)geom.getExteriorRing());
        LinearRing[] holes = new LinearRing[geom.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = this.transform((LinearRing)geom.getInteriorRingN(i));
        }
        return this.gf.createPolygon(exterior, holes);
    }

    protected MultiPolygon transform(MultiPolygon geom) throws TransformException {
        Polygon[] subs = new Polygon[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform((Polygon)geom.getGeometryN(i));
        }
        return this.gf.createMultiPolygon(subs);
    }

    protected GeometryCollection transform(GeometryCollection geom) throws TransformException {
        Geometry[] subs = new Geometry[geom.getNumGeometries()];
        for (int i = 0; i < subs.length; ++i) {
            subs[i] = this.transform(geom.getGeometryN(i));
        }
        return this.gf.createGeometryCollection(subs);
    }
}

