/*
 * Decompiled with CFR 0.152.
 */
package com.bric.util;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;

public final class FloatArrayFactory {
    private static final FloatArrayFactory globalFactory = new FloatArrayFactory();
    private final Map<Number, Deque<float[]>> map = new ConcurrentHashMap<Number, Deque<float[]>>();

    public static FloatArrayFactory getStaticFactory() {
        return globalFactory;
    }

    public float[] getArray(int size) {
        float[] array;
        Deque<float[]> stack = this.map.get(size);
        float[] fArray = array = stack != null ? stack.poll() : null;
        if (array == null) {
            array = new float[size];
        }
        return array;
    }

    public void putArray(float[] array) {
        Deque<float[]> stack = this.map.get(array.length);
        if (stack == null) {
            stack = new ConcurrentLinkedDeque<float[]>();
            this.map.put(array.length, stack);
        }
        stack.push(array);
    }
}

