/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class BooleanValue
extends AtomicValue
implements Comparable {
    private boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.BOOLEAN;
    }

    public static BooleanValue get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public BooleanValue(boolean value, AtomicType typeLabel) {
        this.value = value;
        this.typeLabel = typeLabel;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        BooleanValue v = new BooleanValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public static ConversionResult fromString(CharSequence s2) {
        int len = (s2 = Whitespace.trimWhitespace(s2)).length();
        if (len == 1) {
            char c = s2.charAt(0);
            if (c == '1') {
                return TRUE;
            }
            if (c == '0') {
                return FALSE;
            }
        } else if (len == 4) {
            if (s2.charAt(0) == 't' && s2.charAt(1) == 'r' && s2.charAt(2) == 'u' && s2.charAt(3) == 'e') {
                return TRUE;
            }
        } else if (len == 5 && s2.charAt(0) == 'f' && s2.charAt(1) == 'a' && s2.charAt(2) == 'l' && s2.charAt(3) == 's' && s2.charAt(4) == 'e') {
            return FALSE;
        }
        ValidationFailure err = new ValidationFailure("The string " + Err.wrap(s2, 4) + " cannot be cast to a boolean");
        err.setErrorCode("FORG0001");
        return err;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue() {
        return this.value;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 514: 
            case 632: {
                return this;
            }
            case 532: 
            case 635: {
                return this.value ? Int64Value.PLUS_ONE : Int64Value.ZERO;
            }
            case 515: {
                return this.value ? DecimalValue.ONE : DecimalValue.ZERO;
            }
            case 516: {
                return this.value ? FloatValue.ONE : FloatValue.ZERO;
            }
            case 517: {
                return this.value ? DoubleValue.ONE : DoubleValue.ZERO;
            }
            case 513: {
                return this.value ? StringValue.TRUE : StringValue.FALSE;
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert boolean to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public String getStringValue() {
        return this.value ? "true" : "false";
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (target == Object.class) {
            return this.value;
        }
        if (target.isAssignableFrom(BooleanValue.class)) {
            return this;
        }
        if (target == Boolean.TYPE) {
            return this.value;
        }
        if (target == Boolean.class) {
            return this.value;
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Double.TYPE) {
            return new Double(this.value ? 1 : 0);
        }
        if (target == Double.class) {
            return new Double(this.value ? 1 : 0);
        }
        if (target == Float.TYPE) {
            return new Float(this.value ? 1 : 0);
        }
        if (target == Float.class) {
            return new Float(this.value ? 1 : 0);
        }
        if (target == Long.TYPE) {
            return new Long(this.value ? 1 : 0);
        }
        if (target == Long.class) {
            return new Long(this.value ? 1 : 0);
        }
        if (target == Integer.TYPE) {
            return new Integer(this.value ? 1 : 0);
        }
        if (target == Integer.class) {
            return new Integer(this.value ? 1 : 0);
        }
        if (target == Short.TYPE) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (target == Short.class) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (target == Byte.TYPE) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (target == Byte.class) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (target == Character.TYPE) {
            return new Character(this.value ? (char)'1' : '0');
        }
        if (target == Character.class) {
            return new Character(this.value ? (char)'1' : '0');
        }
        Object o = super.convertToJava(target, context);
        if (o == null) {
            XPathException err = new XPathException("Conversion of xs:boolean to " + target.getName() + " is not supported");
            err.setXPathContext(context);
            err.setErrorCode("SXJE0001");
            throw err;
        }
        return o;
    }

    public Comparable getSchemaComparable() {
        return new BooleanComparable();
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return this;
    }

    public int compareTo(Object other) {
        if (!(other instanceof BooleanValue)) {
            throw new ClassCastException("Boolean values are not comparable to " + other.getClass());
        }
        if (this.value == ((BooleanValue)other).value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object other) {
        BooleanValue val = (BooleanValue)other;
        return this.value == val.value;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    public String toString() {
        return this.getStringValue() + "()";
    }

    private class BooleanComparable
    implements Comparable {
        private BooleanComparable() {
        }

        public boolean asBoolean() {
            return BooleanValue.this.getBooleanValue();
        }

        public int compareTo(Object o) {
            return this.equals(o) ? 0 : Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return o instanceof BooleanComparable && this.asBoolean() == ((BooleanComparable)o).asBoolean();
        }

        public int hashCode() {
            return this.asBoolean() ? 9999999 : 8888888;
        }
    }
}

