/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Vector;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ContNodeIteratorFactoryImpl;
import org.apache.jena.rdf.model.impl.ContainerI;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.NodeIteratorFactory;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.AssertionFailureException;
import org.apache.jena.vocabulary.RDF;

public class ContainerImpl
extends ResourceImpl
implements Container,
ContainerI {
    static NodeIteratorFactory iteratorFactory = new ContNodeIteratorFactoryImpl();

    public ContainerImpl(ModelCom model) {
        super(model);
    }

    public ContainerImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public ContainerImpl(Resource r, ModelCom model) {
        super(r.asNode(), model);
    }

    public ContainerImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    protected ContainerImpl(Resource r) {
        this(r, (ModelCom)r.getModel());
    }

    private boolean is(Resource r) {
        return this.hasProperty(RDF.type, r);
    }

    @Override
    public boolean isAlt() {
        return this.is(RDF.Alt);
    }

    @Override
    public boolean isBag() {
        return this.is(RDF.Bag);
    }

    @Override
    public boolean isSeq() {
        return this.is(RDF.Seq);
    }

    @Override
    public Container add(RDFNode n) {
        int i = this.size();
        this.addProperty(RDF.li(i + 1), n);
        return this;
    }

    @Override
    public Container add(boolean o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(long o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(char o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(float o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(double o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(Object o) {
        return this.add(this.getModel().createTypedLiteral(o));
    }

    @Override
    public Container add(String o) {
        return this.add(o, "");
    }

    @Override
    public Container add(String o, String l) {
        return this.add(this.literal(o, l));
    }

    @Override
    public boolean contains(RDFNode n) {
        return this.containerContains(n);
    }

    @Override
    public boolean contains(boolean o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(long o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(char o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(float o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(double o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(Object o) {
        return this.contains(this.getModel().createTypedLiteral(o));
    }

    @Override
    public boolean contains(String o) {
        return this.contains(o, "");
    }

    @Override
    public boolean contains(String o, String l) {
        return this.contains(this.literal(o, l));
    }

    private Literal literal(String s2, String lang) {
        return new LiteralImpl(NodeFactory.createLiteral(s2, lang), this.getModelCom());
    }

    @Override
    public NodeIterator iterator() {
        return this.listContainerMembers(iteratorFactory);
    }

    @Override
    public int size() {
        int result = 0;
        StmtIterator iter = this.listProperties();
        while (iter.hasNext()) {
            if (iter.nextStatement().getPredicate().getOrdinal() == 0) continue;
            ++result;
        }
        iter.close();
        return result;
    }

    @Override
    public Container remove(Statement s2) {
        int size = this.size();
        Statement last = null;
        if (s2.getPredicate().getOrdinal() == size) {
            this.getModel().remove(s2);
        } else {
            last = this.getModel().getRequiredProperty(this, RDF.li(size));
            s2.changeObject(last.getObject());
            this.getModel().remove(last);
        }
        if (this.size() != size - 1) {
            throw new AssertionFailureException("container size");
        }
        return this;
    }

    @Override
    public Container remove(int index, RDFNode object) {
        this.remove(this.getModel().createStatement((Resource)this, RDF.li(index), object));
        return this;
    }

    public NodeIterator listContainerMembers(NodeIteratorFactory f) {
        StmtIterator iter = this.listProperties();
        Vector<Statement> result = new Vector<Statement>();
        int maxOrdinal = 0;
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            int ordinal = stmt.getPredicate().getOrdinal();
            if (ordinal == 0) continue;
            if (ordinal > maxOrdinal) {
                maxOrdinal = ordinal;
                result.setSize(ordinal);
            }
            result.setElementAt(stmt, ordinal - 1);
        }
        iter.close();
        return f.createIterator(result.iterator(), result, this);
    }

    public int containerIndexOf(RDFNode n) {
        int result = 0;
        StmtIterator iter = this.listProperties();
        while (iter.hasNext()) {
            Statement stmt = iter.nextStatement();
            int ordinal = stmt.getPredicate().getOrdinal();
            if (ordinal == 0 || !n.equals(stmt.getObject())) continue;
            result = ordinal;
            break;
        }
        iter.close();
        return result;
    }

    public boolean containerContains(RDFNode n) {
        return this.containerIndexOf(n) != 0;
    }
}

