/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput0;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfxml.xmlinput0.FatalParsingErrorException;
import org.apache.jena.rdfxml.xmlinput0.SAX2Model;
import org.apache.jena.shared.JenaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class DOM2Model
extends SAX2Model {
    static Logger logger = LoggerFactory.getLogger(DOM2Model.class);

    public static DOM2Model createD2M(String base, Model m4) throws SAXParseException {
        return new DOM2Model(base, m4, "", true);
    }

    public static DOM2Model createD2M(String base, Model m4, String lang) throws SAXParseException {
        return new DOM2Model(base, m4, lang, true);
    }

    DOM2Model(String base, Model m4, String lang, boolean dummy) throws SAXParseException {
        super(base, m4, lang);
    }

    public void load(Node document) {
        DOMSource input = new DOMSource(document);
        SAXResult output = new SAXResult(this);
        output.setLexicalHandler(this);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        try {
            Transformer idTransform = xformFactory.newTransformer();
            idTransform.transform(input, output);
        }
        catch (FatalParsingErrorException e) {
            logger.error("Unexpected exception in DOM2Model", e);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception nrte) {
            throw new JenaException(nrte);
        }
        finally {
            this.close();
        }
    }
}

