/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.AttributeType;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

final class CharacteristicTypeMap
extends AbstractMap<String, AttributeType<?>> {
    private static final WeakValueHashMap<AttributeType<?>[], CharacteristicTypeMap> SHARED = new WeakValueHashMap(AttributeType[].class);
    final AttributeType<?>[] characterizedBy;
    final Map<String, Integer> indices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacteristicTypeMap create(AttributeType<?> source, AttributeType<?>[] characterizedBy) {
        CharacteristicTypeMap map;
        WeakValueHashMap<AttributeType<?>[], CharacteristicTypeMap> weakValueHashMap = SHARED;
        synchronized (weakValueHashMap) {
            map = SHARED.get(characterizedBy);
            if (map == null) {
                map = new CharacteristicTypeMap(source, characterizedBy);
                SHARED.put(characterizedBy, map);
            }
        }
        return map;
    }

    private CharacteristicTypeMap(AttributeType<?> source, AttributeType<?>[] characterizedBy) {
        this.characterizedBy = characterizedBy;
        int index = 0;
        HashMap<String, Integer> indices = new HashMap<String, Integer>(Containers.hashMapCapacity(characterizedBy.length));
        HashMap<String, Integer> aliases = new HashMap<String, Integer>();
        for (int i = 0; i < characterizedBy.length; ++i) {
            AttributeType<?> attribute = characterizedBy[i];
            ArgumentChecks.ensureNonNullElement("characterizedBy", i, attribute);
            GenericName name = attribute.getName();
            String key = AbstractIdentifiedType.toString(name, source, "characterizedBy", i);
            Integer value = index++;
            if (indices.put(key, value) != null) {
                throw new IllegalArgumentException(Errors.format((short)25, key));
            }
            while (name instanceof ScopedName && name != (name = ((ScopedName)name).tail()) && (key = name.toString()) != null && !(key = key.trim()).isEmpty()) {
                if (aliases.put(key, value) == null) continue;
                aliases.put(key, -1);
            }
        }
        for (Map.Entry entry : aliases.entrySet()) {
            Integer value = (Integer)entry.getValue();
            if (value < 0) continue;
            indices.putIfAbsent((String)entry.getKey(), value);
        }
        this.indices = CollectionsExt.compact(indices);
    }

    @Override
    public boolean isEmpty() {
        return this.characterizedBy.length == 0;
    }

    @Override
    public int size() {
        return this.characterizedBy.length;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indices.containsKey(key);
    }

    @Override
    public boolean containsValue(Object key) {
        for (AttributeType<?> type : this.characterizedBy) {
            if (!type.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttributeType<?> get(Object key) {
        Integer index = this.indices.get(key);
        return index != null ? this.characterizedBy[index] : null;
    }

    @Override
    protected AbstractMap.EntryIterator<String, AttributeType<?>> entryIterator() {
        return new AbstractMap.EntryIterator<String, AttributeType<?>>(){
            private int index;
            private AttributeType<?> value;

            @Override
            protected boolean next() {
                if (this.index < CharacteristicTypeMap.this.characterizedBy.length) {
                    this.value = CharacteristicTypeMap.this.characterizedBy[this.index++];
                    return true;
                }
                return false;
            }

            @Override
            protected String getKey() {
                return this.value.getName().toString();
            }

            @Override
            protected AttributeType<?> getValue() {
                return this.value;
            }
        };
    }
}

