/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sis.feature.AssociationView;
import org.apache.sis.feature.AttributeView;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.MultiValuedPropertyException;
import org.opengis.feature.Operation;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyType;

abstract class PropertyView<V>
extends Field<V>
implements Property,
Serializable {
    private static final long serialVersionUID = -5605415150581699255L;
    final Feature feature;
    final String name;

    PropertyView(Feature feature, String name) {
        this.feature = feature;
        this.name = name;
    }

    static Property create(Feature feature, PropertyType type) {
        if (type instanceof AttributeType) {
            return AttributeView.create(feature, (AttributeType)type);
        }
        if (type instanceof FeatureAssociationRole) {
            return AssociationView.create(feature, (FeatureAssociationRole)type);
        }
        if (type instanceof Operation) {
            return ((Operation)type).apply(feature, null);
        }
        throw new IllegalArgumentException(Errors.format((short)149, Classes.getClass(type)));
    }

    abstract Class<V> getValueClass();

    @Override
    public V getValue() throws MultiValuedPropertyException {
        Object value = this.feature.getPropertyValue(this.name);
        if (value instanceof Iterable) {
            Iterator it = ((Iterable)value).iterator();
            if (!it.hasNext()) {
                return null;
            }
            value = it.next();
            if (it.hasNext()) {
                throw new MultiValuedPropertyException(Resources.format((short)53, this.name));
            }
        }
        return this.getValueClass().cast(value);
    }

    @Override
    public void setValue(V value) {
        this.feature.setPropertyValue(this.name, PropertyView.singletonOrEmpty(value));
    }

    static <V> List<V> singletonOrEmpty(V element) {
        return element != null ? Collections.singletonList(element) : Collections.emptyList();
    }

    @Override
    public Collection<V> getValues() {
        Object values = this.feature.getPropertyValue(this.name);
        if (values instanceof Collection) {
            Class actual;
            Class<V> expected;
            if (values instanceof CheckedContainer && (expected = this.getValueClass()) != (actual = ((CheckedContainer)values).getElementType())) {
                throw new ClassCastException(Errors.format((short)143, this.name, expected, actual));
            }
            return (Collection)values;
        }
        return PropertyView.singletonOrEmpty(this.getValueClass().cast(values));
    }

    @Override
    public final void setValues(Collection<? extends V> values) {
        this.feature.setPropertyValue(this.name, values);
    }

    public final int hashCode() {
        return Objects.hashCode(this.name) ^ System.identityHashCode(this.feature);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PropertyView that = (PropertyView)obj;
            return this.feature == that.feature && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final String toString() {
        return FieldType.toString(false, this.getClass().getSimpleName(), this.getName(), Classes.getShortName(this.getValueClass()), this.getValues().iterator()).toString();
    }
}

