/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.filter.BinaryGeometryFilter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.filter.DistanceOperator;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.Expression;
import org.opengis.filter.Literal;
import org.opengis.geometry.Geometry;

final class DistanceFilter<R, G>
extends BinaryGeometryFilter<R, G>
implements DistanceOperator<R> {
    private static final long serialVersionUID = -5304631042699647889L;
    private final DistanceOperatorName operatorType;
    private final Quantity<Length> distance;

    DistanceFilter(DistanceOperatorName operatorType, Geometries<G> library, Expression<R, ?> geometry1, Expression<R, ?> geometry2, Quantity<Length> distance) {
        super(library, geometry1, geometry2, distance.getUnit().getSystemUnit());
        ArgumentChecks.ensureNonNull("operatorType", operatorType);
        this.operatorType = operatorType;
        this.distance = distance;
    }

    @Override
    protected BinaryGeometryFilter<R, G> recreate(Expression<R, ?> geometry1, Expression<R, ?> geometry2) {
        return new DistanceFilter(this.operatorType, DistanceFilter.getGeometryLibrary(this.expression1), geometry1, geometry2, this.distance);
    }

    @Override
    public DistanceOperatorName getOperatorType() {
        return this.operatorType;
    }

    @Override
    public List<Expression<R, ?>> getExpressions() {
        return List.of(DistanceFilter.original(this.expression1), DistanceFilter.original(this.expression2), new LeafExpression.Literal(this.distance));
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(DistanceFilter.original(this.expression1), DistanceFilter.original(this.expression2), this.distance);
    }

    @Override
    public Quantity<Length> getDistance() {
        return this.distance;
    }

    @Override
    public Geometry getGeometry() {
        Literal literal;
        if (this.expression2 instanceof Literal) {
            literal = (Literal)this.expression2;
        } else if (this.expression1 instanceof Literal) {
            literal = (Literal)this.expression1;
        } else {
            throw new IllegalStateException();
        }
        return (Geometry)literal.getValue();
    }

    @Override
    public boolean test(R object) {
        GeometryWrapper right;
        GeometryWrapper left = (GeometryWrapper)this.expression1.apply(object);
        if (left != null && (right = (GeometryWrapper)this.expression2.apply(object)) != null) {
            try {
                return left.predicate(this.operatorType, right, this.distance, this.context);
            }
            catch (RuntimeException e) {
                this.warning(e, true);
            }
        }
        return this.negativeResult();
    }

    @Override
    protected boolean negativeResult() {
        return SpatialOperationContext.negativeResult(this.operatorType);
    }
}

