/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.cat;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.cat.CodeListUID;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;
import org.opengis.util.ControlledVocabulary;

public abstract class CodeListAdapter<ValueType extends CodeListAdapter<ValueType, BoundType>, BoundType extends CodeList<BoundType>>
extends XmlAdapter<ValueType, BoundType> {
    protected CodeListUID identifier;

    protected CodeListAdapter() {
    }

    protected CodeListAdapter(CodeListUID value) {
        this.identifier = value;
    }

    protected abstract ValueType wrap(CodeListUID var1);

    protected abstract Class<BoundType> getCodeListClass();

    protected final boolean accept2014() {
        return FilterByVersion.CURRENT_METADATA.accept();
    }

    @Override
    public final BoundType unmarshal(ValueType adapter) {
        return adapter != null ? (BoundType)Types.forCodeName(this.getCodeListClass(), ((CodeListAdapter)adapter).identifier.toString(), true) : null;
    }

    @Override
    public final ValueType marshal(BoundType code) {
        return code != null ? (ValueType)this.wrap(new CodeListUID(Context.current(), (ControlledVocabulary)code)) : null;
    }

    public abstract CodeListUID getElement();
}

