/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.List;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;

@XmlType(name="MeasureListType")
public final class MeasureList {
    @XmlValue
    public List<Double> values;
    public Unit<?> unit;

    public MeasureList() {
    }

    public <E> MeasureList(final Object array, Class<E> elementType, Unit<?> unit) {
        this.unit = unit;
        final ObjectConverter<E, Double> converter = ObjectConverters.find(elementType, Double.class);
        this.values = new AbstractList<Double>(){

            @Override
            public int size() {
                return Array.getLength(array);
            }

            @Override
            public Double get(int index) {
                return (Double)converter.apply(Array.get(array, index));
            }
        };
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, false, false);
    }

    public void setUOM(String uom) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, uom);
    }

    public double[] toArray() {
        if (this.values == null) {
            return null;
        }
        double[] array = new double[this.values.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.values.get(i);
        }
        return array;
    }
}

