/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL resources) {
        super(resources);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static String format(short key) throws MissingResourceException {
        return Resources.forLocale(null).getString(key);
    }

    public static String format(short key, Object arg0) throws MissingResourceException {
        return Resources.forLocale(null).getString(key, arg0);
    }

    public static String format(short key, Object arg0, Object arg1) throws MissingResourceException {
        return Resources.forLocale(null).getString(key, arg0, arg1);
    }

    public static InternationalString formatInternational(short key) {
        return new International(key);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short BoxCrossesAntiMeridian = 3;
        public static final short ConnectionAlreadyInitialized_1 = 6;
        public static final short ElementAlreadyInitialized_1 = 2;
        public static final short ElementsOmitted_1 = 4;
        public static final short ExpectedInterface_2 = 5;
        public static final short MultilineRecord = 9;
        public static final short SingleNumber = 8;
        public static final short SingleText = 7;
        public static final short UnmodifiableMetadata = 1;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = 7465539282825054584L;

        International(short key) {
            super(key);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }
}

