/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractMercator;
import org.apache.sis.internal.referencing.provider.LambertConformal2SP;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

@XmlTransient
public final class TransverseMercator
extends AbstractMercator {
    private static final long serialVersionUID = -3386587506686432398L;
    public static final String NAME = "Transverse Mercator";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS;

    public TransverseMercator() {
        super(PARAMETERS);
    }

    @Override
    protected NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.TransverseMercator(this, parameters);
    }

    static {
        ParameterBuilder builder = TransverseMercator.builder();
        LATITUDE_OF_ORIGIN = TransverseMercator.createLatitude((ParameterBuilder)builder.addNamesAndIdentifiers(Mercator1SP.LATITUDE_OF_ORIGIN), true);
        LONGITUDE_OF_ORIGIN = TransverseMercator.createLongitude(TransverseMercator.renameAlias(builder, Mercator1SP.LONGITUDE_OF_ORIGIN, Citations.NETCDF, LambertConformal2SP.LONGITUDE_OF_FALSE_ORIGIN));
        SCALE_FACTOR = TransverseMercator.createScale((ParameterBuilder)((ParameterBuilder)builder.addNamesAndIdentifiers(Mercator1SP.SCALE_FACTOR)).rename(Citations.NETCDF, "scale_factor_at_central_meridian"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9807")).addName(NAME)).addName("Gauss-Kruger")).addName("Gauss-Boaga")).addName("TM")).addName(Citations.OGC, "Transverse_Mercator")).addName(Citations.ESRI, "Transverse_Mercator")).addName(Citations.ESRI, "Gauss_Kruger")).addName(Citations.NETCDF, "TransverseMercator")).addName(Citations.GEOTIFF, "CT_TransverseMercator")).addName(Citations.S57, NAME)).addName(Citations.S57, "TME")).addName(Citations.PROJ4, "tmerc")).addIdentifier(Citations.GEOTIFF, "1")).addIdentifier(Citations.MAP_INFO, "8")).addIdentifier(Citations.S57, "13")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }

    public static enum Zoner {
        UTM(-180.0, 6.0, 0.9996, 500000.0, 1.0E7){

            @Override
            public int zone(double \u03c6, double \u03bb) {
                int zone = super.zone(\u03c6, \u03bb);
                switch (zone) {
                    case 31: {
                        if (!1.isNorway(\u03c6) || !(\u03bb >= 3.0)) break;
                        ++zone;
                        break;
                    }
                    case 32: {
                        if (!1.isSvalbard(\u03c6)) break;
                        if (\u03bb >= 9.0) {
                            ++zone;
                            break;
                        }
                        --zone;
                        break;
                    }
                    case 34: {
                        if (!1.isSvalbard(\u03c6)) break;
                        if (\u03bb >= 21.0) {
                            ++zone;
                            break;
                        }
                        --zone;
                        break;
                    }
                    case 36: {
                        if (!1.isSvalbard(\u03c6)) break;
                        if (\u03bb >= 33.0) {
                            ++zone;
                            break;
                        }
                        --zone;
                    }
                }
                return zone;
            }

            @Override
            public boolean isSpecialCase(int zone, double \u03c6) {
                if (zone >= 31 && zone <= 37) {
                    return 1.isSvalbard(\u03c6) || zone <= 32 && 1.isNorway(\u03c6);
                }
                return false;
            }

            @Override
            public boolean isSpecialCase(double \u03c6min, double \u03c6max, double \u03bbmin, double \u03bbmax) {
                if (\u03c6max >= 56.0 && \u03c6min < 84.0) {
                    return super.zone(0.0, \u03bbmax) >= 31 && super.zone(0.0, \u03bbmin) <= 37;
                }
                return false;
            }
        }
        ,
        MTM(-51.5, -3.0, 0.9999, 304800.0, Double.NaN),
        ANY(-180.0, 6.0, 0.9996, 500000.0, 1.0E7);

        public final double origin;
        public final double width;
        public final double scale;
        public final double easting;
        public final double northing;
        public static final double SOUTH_BOUNDS = -80.0;
        private static final double NORWAY_BOUNDS = 56.0;
        public static final double SVALBARD_BOUNDS = 72.0;
        public static final double NORTH_BOUNDS = 84.0;

        private Zoner(double origin, double width, double scale, double easting, double northing) {
            this.origin = origin;
            this.width = width;
            this.scale = scale;
            this.easting = easting;
            this.northing = northing;
        }

        public final String setParameters(ParameterValueGroup group, double latitude, double longitude) {
            Object name;
            boolean isSouth = MathFunctions.isNegative(latitude);
            int zone = this.zone(latitude, longitude);
            if (this == ANY) {
                name = "UTM";
                if (latitude != 0.0 || longitude != this.centralMeridian(zone)) {
                    name = TransverseMercator.NAME;
                    zone = 0;
                }
            } else {
                name = this.name();
                latitude = 0.0;
                longitude = this.centralMeridian(zone);
            }
            if (zone != 0) {
                name = (String)name + " zone " + zone + (isSouth ? (char)'S' : 'N');
            }
            group.parameter("latitude_of_origin").setValue(latitude, Units.DEGREE);
            group.parameter("central_meridian").setValue(longitude, Units.DEGREE);
            group.parameter("scale_factor").setValue(this.scale, Units.UNITY);
            group.parameter("false_easting").setValue(this.easting, Units.METRE);
            group.parameter("false_northing").setValue(isSouth ? this.northing : 0.0, Units.METRE);
            return name;
        }

        public final int zone(ParameterValueGroup group) {
            int zone;
            double v;
            boolean isNorth;
            if (Numerics.epsilonEqual(group.parameter("scale_factor").doubleValue(Units.UNITY), this.scale, 1.0E-13) && Numerics.epsilonEqual(group.parameter("false_easting").doubleValue(Units.METRE), this.easting, 0.01) && Numerics.epsilonEqual(group.parameter("latitude_of_origin").doubleValue(Units.DEGREE), 0.0, 8.999280057595393E-8) && ((isNorth = Numerics.epsilonEqual(v = group.parameter("false_northing").doubleValue(Units.METRE), 0.0, 0.01)) || Numerics.epsilonEqual(v, this.northing, 0.01)) && Numerics.epsilonEqual(this.centralMeridian(zone = this.zone(0.0, v = group.parameter("central_meridian").doubleValue(Units.DEGREE))), v, 8.999280057595393E-8)) {
                if (!isNorth) {
                    zone = -zone;
                }
                return zone;
            }
            return 0;
        }

        public int zone(double \u03c6, double \u03bb) {
            double z = (\u03bb - this.origin) / this.width;
            double count = 360.0 / this.width;
            z -= Math.floor(z / count) * count;
            return (int)(z + 1.0);
        }

        public final int zoneCount() {
            return (int)(360.0 / this.width);
        }

        public final double centralMeridian(int zone) {
            return ((double)zone - 0.5) * this.width + this.origin;
        }

        public boolean isSpecialCase(int zone, double \u03c6) {
            return false;
        }

        public boolean isSpecialCase(double \u03c6min, double \u03c6max, double \u03bbmin, double \u03bbmax) {
            return false;
        }

        public static boolean isNorway(double \u03c6) {
            return \u03c6 >= 56.0 && \u03c6 < 64.0;
        }

        public static boolean isSvalbard(double \u03c6) {
            return \u03c6 >= 72.0 && \u03c6 < 84.0;
        }
    }
}

