/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.folder.Store;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableAggregate;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.util.GenericName;

final class WritableStore
extends Store
implements WritableAggregate {
    private boolean isReadOnly;

    WritableStore(DataStoreProvider provider, StorageConnector connector, Path path, DataStoreProvider format) throws DataStoreException, IOException {
        super(provider, connector, path, format);
    }

    @Override
    public synchronized Resource add(Resource resource) throws DataStoreException {
        Path path;
        ArgumentChecks.ensureNonNull("resource", resource);
        if (!(resource instanceof FeatureSet)) {
            throw new DataStoreException(this.message((short)41, new Object[]{"folder", StoreUtilities.getInterface(resource.getClass())}));
        }
        if (this.isReadOnly) {
            throw new ReadOnlyStorageException(this.messages().getString((short)28));
        }
        GenericName identifier = resource.getIdentifier().orElse(null);
        if (identifier == null) {
            throw new DataStoreException(this.message((short)42, StoreUtilities.getLabel(resource)));
        }
        Object filename = identifier.toString();
        String[] suffixes = StoreUtilities.getFileSuffixes(this.componentProvider.getClass());
        if (suffixes.length != 0) {
            filename = (String)filename + "." + suffixes[0];
        }
        if (!this.children.containsKey(path = this.location.resolve((String)filename))) {
            StorageConnector connector = new StorageConnector(path);
            connector.setOption(OptionKey.LOCALE, this.locale);
            connector.setOption(OptionKey.TIMEZONE, this.timezone);
            connector.setOption(OptionKey.ENCODING, this.encoding);
            connector.setOption(OptionKey.OPEN_OPTIONS, new StandardOpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});
            DataStore store = this.componentProvider.open(connector);
            if (this.children.putIfAbsent(path, store) == null) {
                if (store instanceof WritableFeatureSet) {
                    StoreUtilities.copy((FeatureSet)resource, (WritableFeatureSet)((Object)store));
                    this.components = null;
                    return store;
                }
                this.isReadOnly = true;
                this.children.remove(path, store);
                String name = store.getDisplayName();
                store.close();
                throw new DataStoreException(this.message((short)47, name));
            }
            store.close();
        }
        throw new DataStoreException(this.message((short)48, path));
    }

    @Override
    public synchronized void remove(Resource resource) throws DataStoreException {
        if (resource instanceof DataStore) {
            try {
                if (resource instanceof Store) {
                    Path path = ((Store)resource).location;
                    if (Files.isSameFile(path.getParent(), this.location)) {
                        ((Store)resource).close();
                        WritableStore.deleteRecursively(path, true);
                        this.children.remove(path);
                        return;
                    }
                } else if (resource instanceof ResourceOnFileSystem) {
                    Path[] componentPaths;
                    for (Path root : componentPaths = (Path[])((ResourceOnFileSystem)resource).getComponentFiles().clone()) {
                        if (!Files.isSameFile(root = root.getParent(), this.location)) continue;
                        for (Path path : componentPaths) {
                            if (!path.startsWith(root)) continue;
                            Files.delete(path);
                        }
                        this.children.values().removeIf(e -> e == resource);
                        this.components = null;
                        return;
                    }
                }
            }
            catch (IOException e2) {
                throw new DataStoreException(this.messages().getString((short)49, this.getDisplayName(), ((DataStore)resource).getDisplayName()), e2);
            }
        }
        throw new DataStoreException(this.messages().getString((short)50, this.getDisplayName(), StoreUtilities.getLabel(resource)));
    }

    static void deleteRecursively(Path root, final boolean deleteRoot) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            private int depth;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ++this.depth;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (this.depth > 0) {
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                if (ex != null) {
                    throw ex;
                }
                if (--this.depth > 0 || deleteRoot) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

