/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.sis.internal.jdk17.Record;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.ByteRangeChannel;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.RangeSet;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class FileCacheByteChannel
extends ByteRangeChannel {
    private static final int BUFFER_SIZE = 16384;
    static final int SKIP_THRESHOLD = 65536;
    private static final long TIMEOUT = 2000000000L;
    private volatile Connection connection;
    private Filter filter;
    private final FileChannel file;
    private ByteBuffer transfer;
    private long position;
    private final RangeSet<Long> rangesOfInterest = RangeSet.create(Long.class, true, false);
    private final RangeSet<Long> rangesOfAvailableBytes = RangeSet.create(Long.class, true, false);
    private long length = -1L;
    private IdleConnectionCloser idleHandler;

    protected FileCacheByteChannel(String prefix) throws IOException {
        this.file = FileChannel.open(Files.createTempFile(prefix, null, new FileAttribute[0]), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
    }

    public final void setFilter(Filter filter) {
        this.filter = filter;
    }

    protected abstract String filename();

    protected abstract Connection openConnection(long var1, long var3) throws IOException;

    protected boolean abort(Connection connection) throws IOException {
        return false;
    }

    @Override
    public synchronized long size() throws IOException {
        if (this.length < 0L) {
            if (this.connection == null) {
                this.openConnection();
            }
            if (this.length < 0L) {
                throw new IOException(Errors.format((short)189, "size"));
            }
        }
        return this.length;
    }

    @Override
    public synchronized long position() {
        return this.position;
    }

    @Override
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        if (this.length > 0L) {
            ArgumentChecks.ensureBetween("newPosition", 0L, this.length - 1L, newPosition);
        } else {
            ArgumentChecks.ensurePositive("newPosition", newPosition);
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public final synchronized void rangeOfInterest(long lower, long upper) {
        if (upper > lower) {
            this.rangesOfInterest.add(lower, upper);
        }
    }

    private Connection openConnection() throws IOException {
        long end;
        int i = Math.max(this.rangesOfInterest.indexOfMin(this.position), 0);
        int size = this.rangesOfInterest.size();
        do {
            if (i >= size) {
                end = this.length > 0L ? this.length - 1L : Long.MAX_VALUE;
                break;
            }
            end = this.rangesOfInterest.getMaxLong(i) - 1L;
            ++i;
        } while (end < this.position);
        while (i < size && this.rangesOfInterest.getMinLong(i) - end < 65536L) {
            end = this.rangesOfInterest.getMaxLong(i) - 1L;
            ++i;
        }
        Connection c = this.openConnection(this.position, end);
        this.file.position(c.start);
        if (c.length >= 0L) {
            this.length = c.length;
        }
        this.connection = c;
        if ((end = Math.min(c.end, end)) != Long.MAX_VALUE) {
            ++end;
        }
        this.rangesOfInterest.remove(Math.min(this.position, c.start), end);
        return c;
    }

    private ByteBuffer transfer() {
        if (this.transfer == null) {
            this.transfer = ByteBuffer.allocate(16384);
        }
        return this.transfer;
    }

    private long skipInInput(long count) throws IOException {
        if (count < 0L) {
            throw new IOException(Resources.format((short)18, this.filename()));
        }
        if (count != 0L) {
            int n;
            InputStream input = this.connection.input;
            ByteBuffer buffer = this.transfer();
            do {
                buffer.clear();
                if (count < 16384L) {
                    buffer.limit((int)count);
                }
                if ((n = input.read(buffer.array(), 0, buffer.limit())) <= 0) {
                    if (n != 0 || (n = input.read()) < 0) break;
                    buffer.put(0, (byte)n);
                    n = 1;
                }
                assert (buffer.position() == 0);
                this.cache(buffer.limit(n));
            } while ((count -= (long)n) > 0L);
        }
        return count;
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        ByteBuffer buffer;
        int count = this.readFromCache(dst);
        if (count >= 0) {
            return count;
        }
        Connection c = this.connection;
        long offset = this.position - this.file.position();
        if (c != null && (offset < 0L || c.acceptRanges && (offset >= 65536L || this.position > c.end))) {
            offset -= this.drainAndAbort();
            c = this.connection;
        }
        if (c == null) {
            c = this.openConnection();
            offset = this.position - c.start;
        }
        if ((offset = this.skipInInput(offset)) != 0L) {
            count = this.readFromCache(dst);
            this.usedConnection();
            if (count >= 0) {
                return count;
            }
            throw new EOFException(Errors.format((short)166, "position", 0, this.length, this.position));
        }
        assert (this.file.position() == this.position);
        if (dst.hasArray()) {
            buffer = dst;
        } else {
            buffer = this.transfer();
            buffer.clear().limit(dst.remaining());
        }
        count = c.input.read(buffer.array(), Math.addExact(buffer.arrayOffset(), buffer.position()), buffer.remaining());
        if (count > 0) {
            this.position += (long)count;
            ByteBuffer slice = dst.slice();
            if (buffer != dst) {
                dst.put(buffer.limit(count));
            } else {
                dst.position(dst.position() + count);
            }
            this.cache(slice.limit(count));
        }
        this.usedConnection();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromCache(ByteBuffer dst) throws IOException {
        int count;
        int indexOfRange = this.rangesOfAvailableBytes.indexOfRange(this.position);
        if (indexOfRange < 0) {
            return -1;
        }
        long endOfCache = this.rangesOfAvailableBytes.getMaxLong(indexOfRange);
        int limit = dst.limit();
        int start = dst.position();
        int end = (int)Math.min((long)limit, (long)start + (endOfCache - this.position));
        try {
            count = this.file.read(dst.limit(end), this.position);
            if (count >= 0) {
                this.position += (long)count;
            }
        }
        finally {
            dst.limit(limit);
        }
        assert (dst.position() == start + count);
        return count;
    }

    private void cache(ByteBuffer buffer) throws IOException {
        do {
            long start = this.file.position();
            int count = this.file.write(buffer);
            if (count <= 0) {
                throw new IOException();
            }
            long end = start + (long)count;
            if (end < start) {
                end = Long.MAX_VALUE;
            }
            this.rangesOfAvailableBytes.add(start, end);
        } while (buffer.hasRemaining());
    }

    private long drainAndAbort() throws IOException {
        int r;
        assert (Thread.holdsLock(this));
        long count = 0L;
        Connection c = this.connection;
        InputStream input = c.input;
        while ((r = input.available()) > 0) {
            int n;
            ByteBuffer buffer = this.transfer();
            buffer.clear();
            if (r < 16384) {
                buffer.limit(r);
            }
            if ((n = input.read(buffer.array(), 0, buffer.limit())) < 0) break;
            this.cache(buffer.limit(n));
            count += (long)n;
        }
        if (this.abort(c)) {
            this.connection = null;
        }
        return count;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public boolean isOpen() {
        return this.file.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SeekableByteChannel seekableByteChannel;
        Connection c = this.connection;
        try {
            seekableByteChannel = this.file;
            try {
                if (c != null && !this.abort(c)) {
                    c.input.close();
                }
            }
            finally {
                if (seekableByteChannel != null) {
                    seekableByteChannel.close();
                }
            }
        }
        finally {
            seekableByteChannel = this;
            synchronized (seekableByteChannel) {
                this.transfer = null;
                this.idleHandler = null;
                this.connection = null;
            }
        }
    }

    private void usedConnection() {
        assert (Thread.holdsLock(this));
        Connection c = this.connection;
        if (c != null && c.acceptRanges) {
            long lastReadTime = System.nanoTime();
            if (this.idleHandler != null) {
                this.idleHandler.lastReadTime = lastReadTime;
            } else {
                this.idleHandler = new IdleConnectionCloser(lastReadTime);
                DelayedExecutor.schedule(this.idleHandler);
            }
        }
    }

    public synchronized String toString() {
        return Strings.toString(this.getClass(), "filename", this.filename(), "position", this.position, "rangesOfAvailableBytes", this.rangesOfAvailableBytes.size(), "rangesOfInterest", this.rangesOfInterest.size());
    }

    public static interface Filter {
        public InputStream apply(InputStream var1, long var2, long var4);
    }

    protected static final class Connection
    extends Record {
        private static final String RANGES_UNIT = "bytes";
        public final InputStream rawInput;
        public final InputStream input;
        final long start;
        final long end;
        final long length;
        final boolean acceptRanges;

        public Connection(FileCacheByteChannel owner, InputStream input, long start, long end, long length, boolean acceptRanges) {
            this.rawInput = input;
            this.start = start;
            this.end = end;
            this.length = length;
            this.acceptRanges = acceptRanges;
            this.input = this.filter(owner, input);
        }

        public Connection(FileCacheByteChannel owner, InputStream input, long contentLength, Iterable<String> rangeUnits) {
            this.rawInput = input;
            this.start = 0L;
            this.end = contentLength > 0L ? contentLength - 1L : Long.MAX_VALUE;
            this.length = contentLength;
            this.acceptRanges = Connection.acceptRanges(rangeUnits);
            this.input = this.filter(owner, input);
        }

        public Connection(FileCacheByteChannel owner, InputStream input, String contentRange, Collection<String> rangeUnits) {
            String t2;
            int rs;
            int ls;
            this.rawInput = input;
            long contentLength = -1L;
            contentRange = contentRange.trim();
            int s2 = contentRange.indexOf(32);
            if (!(s2 < 0 || s2 == RANGES_UNIT.length() && contentRange.regionMatches(true, 0, RANGES_UNIT, 0, s2))) {
                throw new IllegalArgumentException(Errors.format((short)170, contentRange));
            }
            if ((ls = contentRange.indexOf(47, Math.max(++s2, (rs = contentRange.indexOf(45, s2)) + 1))) >= 0 && !(t2 = contentRange.substring(ls + 1).trim()).equals("*")) {
                contentLength = Long.parseLong(t2);
            }
            this.length = contentLength;
            if (ls < 0) {
                ls = contentRange.length();
            }
            if (rs < 0) {
                rs = ls;
            }
            this.start = Long.parseLong(contentRange.substring(s2, rs).trim());
            this.end = rs < ls ? Long.parseLong(contentRange.substring(rs + 1, ls).trim()) : this.length;
            this.acceptRanges = rangeUnits.isEmpty() || Connection.acceptRanges(rangeUnits);
            this.input = this.filter(owner, input);
        }

        private InputStream filter(FileCacheByteChannel owner, InputStream input) {
            Filter filter;
            if (owner != null && (filter = owner.filter) != null) {
                input = filter.apply(input, this.start, this.end);
            }
            return input;
        }

        private static boolean acceptRanges(Iterable<String> values) {
            for (String t2 : values) {
                if (!ArraysExt.containsIgnoreCase((String[])CharSequences.split(t2, ','), RANGES_UNIT)) continue;
                return true;
            }
            return false;
        }

        public static String formatRange(long start, long end) {
            boolean hasEnd;
            boolean bl = hasEnd = end > start && end != Long.MAX_VALUE;
            if (start == 0L && !hasEnd) {
                return null;
            }
            StringBuilder range = new StringBuilder(RANGES_UNIT).append('=').append(start).append('-');
            if (hasEnd) {
                range.append(end);
            }
            return range.toString();
        }

        public String toString() {
            return Strings.toString(this.getClass(), null, Connection.formatRange(this.start, this.end));
        }
    }

    private final class IdleConnectionCloser
    extends DelayedRunnable {
        long lastReadTime;

        IdleConnectionCloser(long lastReadTime) {
            super(lastReadTime + 2000000000L);
            this.lastReadTime = lastReadTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileCacheByteChannel fileCacheByteChannel = FileCacheByteChannel.this;
            synchronized (fileCacheByteChannel) {
                FileCacheByteChannel.this.idleHandler = null;
                Connection c = FileCacheByteChannel.this.connection;
                if (c != null && c.acceptRanges) {
                    if (System.nanoTime() - this.lastReadTime < 2000000000L) {
                        FileCacheByteChannel.this.idleHandler = new IdleConnectionCloser(this.lastReadTime);
                    } else {
                        try {
                            FileCacheByteChannel.this.drainAndAbort();
                        }
                        catch (IOException e) {
                            Logging.unexpectedException(StoreUtilities.LOGGER, IdleConnectionCloser.class, "run", e);
                        }
                    }
                }
            }
        }
    }
}

