/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.sis.internal.storage.DocumentedStoreProvider;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.xml.MimeTypeDetector;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

public abstract class AbstractProvider
extends DocumentedStoreProvider {
    public static final String MIME_TYPE = "application/xml";
    private static final int READ_AHEAD_LIMIT = 2048;
    private static final byte[] HEADER = new byte[]{60, 63, 120, 109, 108, 32};
    protected final Map<String, String> mimeForNameSpaces;
    protected final Map<String, String> mimeForRootElements;

    protected AbstractProvider(String name, Map<String, String> mimeForNameSpaces, Map<String, String> mimeForRootElements) {
        super(name);
        this.mimeForNameSpaces = mimeForNameSpaces;
        this.mimeForRootElements = mimeForRootElements;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        DataStoreProvider.Prober<ByteBuffer> prober = buffer -> {
            if (buffer.remaining() < HEADER.length) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            for (int i = 0; i < HEADER.length; ++i) {
                if (buffer.get() == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            return new MimeTypeDetector(this.mimeForNameSpaces, this.mimeForRootElements, (ByteBuffer)buffer){
                final /* synthetic */ ByteBuffer val$buffer;
                {
                    this.val$buffer = byteBuffer;
                    super(mimeForNameSpaces, mimeForRootElements);
                }

                @Override
                int read() {
                    if (this.val$buffer.hasRemaining()) {
                        return this.val$buffer.get();
                    }
                    this.insufficientBytes = this.val$buffer.limit() != this.val$buffer.capacity();
                    return -1;
                }
            }.probeContent();
        };
        return this.probeContent(connector, ByteBuffer.class, prober.orElse(Reader.class, reader -> {
            for (int i = 0; i < HEADER.length; ++i) {
                if (reader.read() == HEADER[i]) continue;
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
            return new MimeTypeDetector(this.mimeForNameSpaces, this.mimeForRootElements, (Reader)reader){
                private int remaining;
                final /* synthetic */ Reader val$reader;
                {
                    this.val$reader = reader;
                    super(mimeForNameSpaces, mimeForRootElements);
                    this.remaining = 2048;
                }

                @Override
                int read() throws IOException {
                    return --this.remaining >= 0 ? IOUtilities.readCodePoint(this.val$reader) : -1;
                }
            }.probeContent();
        }));
    }
}

