/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public final class X364
extends Enum<X364> {
    public static final /* enum */ X364 RESET = new X364(0, null);
    public static final /* enum */ X364 NORMAL = new X364(22, null);
    public static final /* enum */ X364 BOLD = new X364(1, null);
    public static final /* enum */ X364 FAINT = new X364(2, null);
    public static final /* enum */ X364 UNDERLINE = new X364(4, null);
    public static final /* enum */ X364 NO_UNDERLINE = new X364(24, null);
    public static final /* enum */ X364 FOREGROUND_RED = new X364(31, "red");
    public static final /* enum */ X364 FOREGROUND_GREEN = new X364(32, "green");
    public static final /* enum */ X364 FOREGROUND_YELLOW = new X364(33, "yellow");
    public static final /* enum */ X364 FOREGROUND_BLUE = new X364(34, "blue");
    public static final /* enum */ X364 FOREGROUND_MAGENTA = new X364(35, "magenta");
    public static final /* enum */ X364 FOREGROUND_CYAN = new X364(36, "cyan");
    public static final /* enum */ X364 FOREGROUND_GRAY = new X364(37, "gray");
    public static final /* enum */ X364 FOREGROUND_DEFAULT = new X364(39, null);
    public static final /* enum */ X364 BACKGROUND_RED = new X364(FOREGROUND_RED);
    public static final /* enum */ X364 BACKGROUND_GREEN = new X364(FOREGROUND_GREEN);
    public static final /* enum */ X364 BACKGROUND_YELLOW = new X364(FOREGROUND_YELLOW);
    public static final /* enum */ X364 BACKGROUND_BLUE = new X364(FOREGROUND_BLUE);
    public static final /* enum */ X364 BACKGROUND_MAGENTA = new X364(FOREGROUND_MAGENTA);
    public static final /* enum */ X364 BACKGROUND_CYAN = new X364(FOREGROUND_CYAN);
    public static final /* enum */ X364 BACKGROUND_GRAY = new X364(FOREGROUND_GRAY);
    public static final /* enum */ X364 BACKGROUND_DEFAULT = new X364(FOREGROUND_DEFAULT);
    private static final X364[] NAMED;
    public static final char ESCAPE = '\u001b';
    public static final char BRACKET = '[';
    private static final String START = "\u001b[";
    private static final char END = 'm';
    private final transient byte code;
    private transient String sequence;
    private transient X364 foreground;
    private transient X364 background;
    public final String color;
    private static final /* synthetic */ X364[] $VALUES;

    public static X364[] values() {
        return (X364[])$VALUES.clone();
    }

    public static X364 valueOf(String name) {
        return Enum.valueOf(X364.class, name);
    }

    private X364(byte code, String color) {
        this.code = code;
        this.color = color;
        this.foreground = this;
        this.background = this;
    }

    private X364(X364 foreground) {
        this((byte)(foreground.code + 10), foreground.color);
        this.foreground = foreground;
        this.background = foreground.background = this;
    }

    public X364 foreground() {
        return this.foreground;
    }

    public X364 background() {
        return this.background;
    }

    public String sequence() {
        if (this.sequence == null) {
            this.sequence = (START + this.code + "m").intern();
        }
        return this.sequence;
    }

    public static CharSequence plain(CharSequence text, int fromIndex, int toIndex) {
        int i = CharSequences.indexOf(text, START, fromIndex, toIndex);
        if (i >= 0) {
            StringBuilder buffer = null;
            block0: do {
                int start = i;
                int end = CharSequences.indexOf(text, 109, i += START.length(), toIndex);
                if (end < 0) break;
                while (i < end) {
                    char c;
                    if ((c = text.charAt(i++)) >= '0' && c <= '9') continue;
                    continue block0;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(toIndex - fromIndex);
                }
                buffer.append(text, fromIndex, start);
                fromIndex = ++i;
            } while ((i = CharSequences.indexOf(text, START, i, toIndex)) >= 0);
            if (buffer != null) {
                return buffer.append(text, fromIndex, toIndex);
            }
        }
        return text.subSequence(fromIndex, toIndex);
    }

    public static int lengthOfPlain(CharSequence text, int fromIndex, int toIndex) {
        int i = CharSequences.indexOf(text, START, fromIndex, toIndex);
        if (i < 0) {
            return CharSequences.codePointCount(text, fromIndex, toIndex);
        }
        int last = fromIndex;
        int length = 0;
        block0: do {
            int start = i;
            int end = CharSequences.indexOf(text, 109, i += START.length(), toIndex);
            if (end < 0) break;
            while (i < end) {
                char c;
                if ((c = text.charAt(i++)) >= '0' && c <= '9') continue;
                continue block0;
            }
            length += CharSequences.codePointCount(text, last, start);
            last = ++i;
        } while ((i = CharSequences.indexOf(text, START, i, toIndex)) >= 0);
        assert (CharSequences.codePointCount(X364.plain(text, fromIndex, toIndex)) == (length += CharSequences.codePointCount(text, last, toIndex))) : text.subSequence(fromIndex, toIndex);
        return length;
    }

    public static X364 forColorName(String color) throws IllegalArgumentException {
        color = color.strip();
        ArgumentChecks.ensureNonEmpty("color", color);
        for (X364 code : NAMED) {
            if (!color.equalsIgnoreCase(code.color)) continue;
            return code;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "color", color));
    }

    public static boolean isAnsiSupported() {
        String terminal;
        try {
            terminal = System.getenv("COLORTERM");
            if (terminal != null) {
                return true;
            }
            terminal = System.getenv("CLICOLOR");
        }
        catch (SecurityException e) {
            return false;
        }
        if (terminal != null) {
            try {
                return Integer.parseInt(terminal) != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ X364[] $values() {
        return new X364[]{RESET, NORMAL, BOLD, FAINT, UNDERLINE, NO_UNDERLINE, FOREGROUND_RED, FOREGROUND_GREEN, FOREGROUND_YELLOW, FOREGROUND_BLUE, FOREGROUND_MAGENTA, FOREGROUND_CYAN, FOREGROUND_GRAY, FOREGROUND_DEFAULT, BACKGROUND_RED, BACKGROUND_GREEN, BACKGROUND_YELLOW, BACKGROUND_BLUE, BACKGROUND_MAGENTA, BACKGROUND_CYAN, BACKGROUND_GRAY, BACKGROUND_DEFAULT};
    }

    static {
        $VALUES = X364.$values();
        NAMED = Arrays.copyOfRange(X364.values(), 6, 13);
    }
}

