/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public class StatisticsFormat
extends TabularFormat<Statistics> {
    private static final long serialVersionUID = 6914760410359494163L;
    private final Locale headerLocale;
    private byte borderWidth;
    private boolean allPopulation;
    private static final short[] KEYS = new short[]{146, 145, 134, 128, 129, 177, 185};

    public static StatisticsFormat getInstance() {
        return new StatisticsFormat(Locale.getDefault(Locale.Category.FORMAT), Locale.getDefault(Locale.Category.DISPLAY), null);
    }

    public static StatisticsFormat getInstance(Locale locale) {
        return new StatisticsFormat(locale, locale, null);
    }

    public StatisticsFormat(Locale locale, Locale headerLocale, TimeZone timezone) {
        super(locale, timezone);
        this.headerLocale = headerLocale != null ? headerLocale : Locale.ROOT;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.DISPLAY) {
            return this.headerLocale;
        }
        return super.getLocale(category);
    }

    @Override
    public final Class<Statistics> getValueType() {
        return Statistics.class;
    }

    public boolean isForAllPopulation() {
        return this.allPopulation;
    }

    public void setForAllPopulation(boolean allPopulation) {
        this.allPopulation = allPopulation;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        ArgumentChecks.ensureBetween("borderWidth", 0, 2, borderWidth);
        this.borderWidth = (byte)borderWidth;
    }

    @Override
    public Statistics parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.format((short)162, "parse"), pos.getIndex());
    }

    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition pos) {
        if (object instanceof Statistics[]) {
            try {
                this.format((Statistics[])object, (Appendable)toAppendTo);
                return toAppendTo;
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
        return super.format(object, toAppendTo, pos);
    }

    @Override
    public void format(Statistics stats, Appendable toAppendTo) throws IOException {
        ArrayList<Statistics> list = new ArrayList<Statistics>(3);
        while (stats != null) {
            list.add(stats);
            stats = stats.differences();
        }
        this.format((Statistics[])list.toArray(Statistics[]::new), toAppendTo);
    }

    @Override
    public void format(Statistics[] stats, Appendable toAppendTo) throws IOException {
        String[] headers = new String[stats.length];
        boolean showHeaders = false;
        boolean showNaNCount = false;
        for (int i = 0; i < stats.length; ++i) {
            Statistics s2 = stats[i];
            showNaNCount |= s2.countNaN() != 0;
            InternationalString header = s2.name();
            if (header == null) continue;
            headers[i] = header.toString(this.headerLocale);
            showHeaders |= headers[i] != null;
        }
        char horizontalLine = '\u0000';
        Object separator = this.columnSeparator;
        switch (this.borderWidth) {
            case 1: {
                horizontalLine = '\u2500';
                separator = (String)separator + "\u2502 ";
                break;
            }
            case 2: {
                horizontalLine = '\u2550';
                separator = (String)separator + "\u2551 ";
            }
        }
        TableAppender table = new TableAppender(toAppendTo, (String)separator);
        Vocabulary resources = Vocabulary.getResources(this.headerLocale);
        if (horizontalLine != '\u0000') {
            table.nextLine(horizontalLine);
        }
        if (showHeaders) {
            table.nextColumn();
            for (String header : headers) {
                if (header != null) {
                    table.append(header);
                    table.setCellAlignment((byte)0);
                }
                table.nextColumn();
            }
            table.append(this.lineSeparator);
            if (horizontalLine != '\u0000') {
                table.nextLine(horizontalLine);
            }
        }
        Format countFormat = this.getFormat(Integer.class);
        Format valueFormat = this.getFormat(Double.class);
        Format[] formats = new Format[stats.length];
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StatisticsFormat.configure(valueFormat, stats[i], i != 0);
        }
        for (int line = 0; line < KEYS.length; ++line) {
            if (line == 1 & !showNaNCount) continue;
            table.setCellAlignment((byte)-1);
            table.append(resources.getString(KEYS[line])).append(':');
            for (int i = 0; i < stats.length; ++i) {
                Number value;
                Statistics s3 = stats[i];
                switch (line) {
                    case 0: {
                        value = s3.count();
                        break;
                    }
                    case 1: {
                        value = s3.countNaN();
                        break;
                    }
                    case 2: {
                        value = s3.minimum();
                        break;
                    }
                    case 3: {
                        value = s3.maximum();
                        break;
                    }
                    case 4: {
                        value = s3.mean();
                        break;
                    }
                    case 5: {
                        value = s3.rms();
                        break;
                    }
                    case 6: {
                        value = s3.standardDeviation(this.allPopulation);
                        break;
                    }
                    default: {
                        throw new AssertionError(line);
                    }
                }
                table.append(this.beforeFill);
                table.nextColumn(this.fillCharacter);
                table.append((line >= 2 ? formats[i] : countFormat).format(value));
                table.setCellAlignment((byte)1);
            }
            table.append(this.lineSeparator);
        }
        if (horizontalLine != '\u0000') {
            table.nextLine(horizontalLine);
        }
        table.flush();
    }

    private static Format configure(Format format, Statistics stats, boolean clone) {
        int multiplier = 1;
        if (format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            multiplier = df.getMultiplier();
            double extremum = Math.max(Math.abs(stats.minimum()), Math.abs(stats.maximum()));
            if (multiplier == 1 && (extremum >= 1.0E10 || extremum <= 1.0E-4)) {
                String pattern = df.toPattern();
                int i = pattern.length();
                while (--i >= 0) {
                    switch (pattern.charAt(i)) {
                        case '\'': 
                        case 'E': 
                        case '\u00a4': {
                            return format;
                        }
                    }
                }
                df = (DecimalFormat)df.clone();
                df.applyPattern("0.00000E00");
                return df;
            }
        }
        if (format instanceof NumberFormat) {
            NumberFormat nf;
            int digits = Numerics.suggestFractionDigits(stats);
            digits -= DecimalFunctions.floorLog10(multiplier);
            if ((digits = Math.max(0, digits)) != (nf = (NumberFormat)format).getMinimumFractionDigits() || digits != nf.getMaximumFractionDigits()) {
                if (clone) {
                    nf = (NumberFormat)nf.clone();
                }
                nf.setMinimumFractionDigits(digits);
                nf.setMaximumFractionDigits(digits);
            }
            return nf;
        }
        return format;
    }

    @Override
    public StatisticsFormat clone() {
        return (StatisticsFormat)super.clone();
    }
}

