/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.EnvironmentalRecord;
import org.opengis.util.InternationalString;

@XmlType(name="MI_EnvironmentalRecord_Type", propOrder={"averageAirTemperature", "maxRelativeHumidity", "maxAltitude", "meteorologicalConditions"})
@XmlRootElement(name="MI_EnvironmentalRecord")
public class DefaultEnvironmentalRecord
extends ISOMetadata
implements EnvironmentalRecord {
    private static final long serialVersionUID = 3634348015931833471L;
    private Double averageAirTemperature;
    private Double maxRelativeHumidity;
    private Double maxAltitude;
    private InternationalString meteorologicalConditions;

    public DefaultEnvironmentalRecord() {
    }

    public DefaultEnvironmentalRecord(EnvironmentalRecord object) {
        super(object);
        if (object != null) {
            this.averageAirTemperature = object.getAverageAirTemperature();
            this.maxRelativeHumidity = object.getMaxRelativeHumidity();
            this.maxAltitude = object.getMaxAltitude();
            this.meteorologicalConditions = object.getMeteorologicalConditions();
        }
    }

    public static DefaultEnvironmentalRecord castOrCopy(EnvironmentalRecord object) {
        if (object == null || object instanceof DefaultEnvironmentalRecord) {
            return (DefaultEnvironmentalRecord)object;
        }
        return new DefaultEnvironmentalRecord(object);
    }

    @Override
    @XmlElement(name="averageAirTemperature", required=true)
    public Double getAverageAirTemperature() {
        return this.averageAirTemperature;
    }

    public void setAverageAirTemperature(Double newValue) {
        this.checkWritePermission(this.averageAirTemperature);
        this.averageAirTemperature = newValue;
    }

    @Override
    @ValueRange(minimum=0.0, maximum=100.0)
    @XmlElement(name="maxRelativeHumidity", required=true)
    public Double getMaxRelativeHumidity() {
        return this.maxRelativeHumidity;
    }

    public void setMaxRelativeHumidity(Double newValue) {
        this.checkWritePermission(this.maxRelativeHumidity);
        if (ImplementationHelper.ensureInRange(DefaultEnvironmentalRecord.class, "maxRelativeHumidity", 0, 100, newValue)) {
            this.maxRelativeHumidity = newValue;
        }
    }

    @Override
    @XmlElement(name="maxAltitude", required=true)
    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public void setMaxAltitude(Double newValue) {
        this.checkWritePermission(this.maxAltitude);
        this.maxAltitude = newValue;
    }

    @Override
    @XmlElement(name="meterologicalConditions", required=true)
    public InternationalString getMeteorologicalConditions() {
        return this.meteorologicalConditions;
    }

    public void setMeteorologicalConditions(InternationalString newValue) {
        this.checkWritePermission(this.meteorologicalConditions);
        this.meteorologicalConditions = newValue;
    }
}

