/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.jaxb.lan.PT_Locale;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.metadata.content.FeatureTypeInfo;
import org.opengis.util.GenericName;

@XmlType(name="MD_FeatureCatalogueDescription_Type", propOrder={"compliant", "locale", "languages", "includedWithDataset", "featureTypesInfo", "featureTypes", "featureCatalogueCitations"})
@XmlRootElement(name="MD_FeatureCatalogueDescription")
public class DefaultFeatureCatalogueDescription
extends AbstractContentInformation
implements FeatureCatalogueDescription {
    private static final long serialVersionUID = 4637544662644655274L;
    private Boolean compliant;
    private Map<Locale, Charset> locales;
    private boolean includedWithDataset;
    private Collection<FeatureTypeInfo> featureTypes;
    private Collection<Citation> featureCatalogueCitations;

    public DefaultFeatureCatalogueDescription() {
    }

    public DefaultFeatureCatalogueDescription(FeatureCatalogueDescription object) {
        super(object);
        if (object != null) {
            this.compliant = object.isCompliant();
            this.includedWithDataset = object.isIncludedWithDataset();
            this.locales = this.copyMap(object.getLocalesAndCharsets(), Locale.class);
            this.featureTypes = this.copyCollection(object.getFeatureTypeInfo(), FeatureTypeInfo.class);
            this.featureCatalogueCitations = this.copyCollection(object.getFeatureCatalogueCitations(), Citation.class);
        }
    }

    public static DefaultFeatureCatalogueDescription castOrCopy(FeatureCatalogueDescription object) {
        if (object == null || object instanceof DefaultFeatureCatalogueDescription) {
            return (DefaultFeatureCatalogueDescription)object;
        }
        return new DefaultFeatureCatalogueDescription(object);
    }

    @Override
    @XmlElement(name="complianceCode")
    public Boolean isCompliant() {
        return this.compliant;
    }

    public void setCompliant(Boolean newValue) {
        this.checkWritePermission(this.compliant);
        this.compliant = newValue;
    }

    @Override
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> newValues) {
        this.locales = this.writeMap(newValues, this.locales, Locale.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated(since="1.0")
    public void setLanguages(Collection<? extends Locale> newValues) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), newValues));
    }

    @Override
    @XmlElement(name="includedWithDataset")
    public boolean isIncludedWithDataset() {
        return this.includedWithDataset;
    }

    public void setIncludedWithDataset(boolean newValue) {
        this.checkWritePermission(this.includedWithDataset ? Boolean.TRUE : null);
        this.includedWithDataset = newValue;
    }

    public Collection<FeatureTypeInfo> getFeatureTypeInfo() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, FeatureTypeInfo.class);
        return this.featureTypes;
    }

    public void setFeatureTypeInfo(Collection<? extends FeatureTypeInfo> newValues) {
        this.featureTypes = this.writeCollection(newValues, this.featureTypes, FeatureTypeInfo.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getFeatureTypeInfo"})
    @XmlElement(name="featureTypes", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<GenericName> getFeatureTypes() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<GenericName, FeatureTypeInfo>(this.getFeatureTypeInfo()){

            @Override
            protected FeatureTypeInfo wrap(GenericName value) {
                return new DefaultFeatureTypeInfo(value);
            }

            @Override
            protected GenericName unwrap(FeatureTypeInfo container) {
                return container.getFeatureTypeName();
            }

            @Override
            protected boolean update(FeatureTypeInfo container, GenericName value) {
                if (container instanceof DefaultFeatureTypeInfo) {
                    ((DefaultFeatureTypeInfo)container).setFeatureTypeName(value);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setFeatureTypes(Collection<? extends GenericName> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.featureTypes));
        ((LegacyPropertyAdapter)this.getFeatureTypes()).setValues(newValues);
    }

    @XmlElement(name="featureCatalogueCitation")
    public Collection<Citation> getFeatureCatalogueCitations() {
        this.featureCatalogueCitations = this.nonNullCollection(this.featureCatalogueCitations, Citation.class);
        return this.featureCatalogueCitations;
    }

    public void setFeatureCatalogueCitations(Collection<? extends Citation> newValues) {
        this.featureCatalogueCitations = this.writeCollection(newValues, this.featureCatalogueCitations, Citation.class);
    }

    @XmlElement(name="featureTypes")
    private Collection<FeatureTypeInfo> getFeatureTypesInfo() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getFeatureTypeInfo() : null;
    }

    @XmlElement(name="locale")
    private Collection<PT_Locale> getLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.wrap(this.locales) : null;
    }
}

