/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.Scope;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

@XmlType(name="MD_MaintenanceInformation_Type", propOrder={"maintenanceAndUpdateFrequency", "maintenanceDate", "dateOfNextUpdate", "userDefinedMaintenanceFrequency", "maintenanceScope", "updateScopes", "updateScopeDescriptions", "maintenanceNotes", "contacts"})
@XmlRootElement(name="MD_MaintenanceInformation")
public class DefaultMaintenanceInformation
extends ISOMetadata
implements MaintenanceInformation {
    private static final long serialVersionUID = -8736825706141936429L;
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private Collection<CitationDate> maintenanceDates;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection<Scope> maintenanceScopes;
    private Collection<InternationalString> maintenanceNotes;
    private Collection<Responsibility> contacts;

    public DefaultMaintenanceInformation() {
    }

    public DefaultMaintenanceInformation(MaintenanceFrequency maintenanceAndUpdateFrequency) {
        this.maintenanceAndUpdateFrequency = maintenanceAndUpdateFrequency;
    }

    public DefaultMaintenanceInformation(MaintenanceInformation object) {
        super(object);
        if (object != null) {
            this.maintenanceAndUpdateFrequency = object.getMaintenanceAndUpdateFrequency();
            this.maintenanceDates = this.copyCollection(object.getMaintenanceDates(), CitationDate.class);
            this.userDefinedMaintenanceFrequency = object.getUserDefinedMaintenanceFrequency();
            this.maintenanceScopes = this.copyCollection(object.getMaintenanceScopes(), Scope.class);
            this.maintenanceNotes = this.copyCollection(object.getMaintenanceNotes(), InternationalString.class);
            this.contacts = this.copyCollection(object.getContacts(), Responsibility.class);
        }
    }

    public static DefaultMaintenanceInformation castOrCopy(MaintenanceInformation object) {
        if (object == null || object instanceof DefaultMaintenanceInformation) {
            return (DefaultMaintenanceInformation)object;
        }
        return new DefaultMaintenanceInformation(object);
    }

    @Override
    @XmlElement(name="maintenanceAndUpdateFrequency")
    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public void setMaintenanceAndUpdateFrequency(MaintenanceFrequency newValue) {
        this.checkWritePermission(this.maintenanceAndUpdateFrequency);
        this.maintenanceAndUpdateFrequency = newValue;
    }

    public Collection<CitationDate> getMaintenanceDates() {
        this.maintenanceDates = this.nonNullCollection(this.maintenanceDates, CitationDate.class);
        return this.maintenanceDates;
    }

    public void setMaintenanceDates(Collection<? extends CitationDate> newValues) {
        this.maintenanceDates = this.writeCollection(newValues, this.maintenanceDates, CitationDate.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getMaintenanceDates"})
    @XmlElement(name="dateOfNextUpdate", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDateOfNextUpdate() {
        Collection<CitationDate> dates;
        if (FilterByVersion.LEGACY_METADATA.accept() && (dates = this.getMaintenanceDates()) != null) {
            for (CitationDate date : dates) {
                if (!DateType.NEXT_UPDATE.equals(date.getDateType())) continue;
                return date.getDate();
            }
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setDateOfNextUpdate(Date newValue) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceDates));
        Collection<CitationDate> dates = this.maintenanceDates;
        if (dates != null) {
            Iterator<CitationDate> it = dates.iterator();
            while (it.hasNext()) {
                CitationDate date = it.next();
                if (!DateType.NEXT_UPDATE.equals(date.getDateType())) continue;
                if (newValue == null) {
                    it.remove();
                    return;
                }
                if (!(date instanceof DefaultCitationDate)) continue;
                ((DefaultCitationDate)date).setDate(newValue);
                return;
            }
        }
        if (newValue != null) {
            DefaultCitationDate date = new DefaultCitationDate(newValue, DateType.NEXT_UPDATE);
            if (dates != null) {
                dates.add(date);
            } else {
                dates = Collections.singleton(date);
            }
            this.setMaintenanceDates(dates);
        }
    }

    @Override
    @XmlElement(name="userDefinedMaintenanceFrequency")
    public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public void setUserDefinedMaintenanceFrequency(PeriodDuration newValue) {
        this.checkWritePermission(this.userDefinedMaintenanceFrequency);
        this.userDefinedMaintenanceFrequency = newValue;
    }

    public Collection<Scope> getMaintenanceScopes() {
        this.maintenanceScopes = this.nonNullCollection(this.maintenanceScopes, Scope.class);
        return this.maintenanceScopes;
    }

    public void setMaintenanceScopes(Collection<? extends Scope> newValues) {
        this.maintenanceScopes = this.writeCollection(newValues, this.maintenanceScopes, Scope.class);
    }

    @Override
    @Deprecated(since="1.0")
    @Dependencies(value={"getMaintenanceScopes"})
    @XmlElement(name="updateScope", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeCode> getUpdateScopes() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<ScopeCode, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeCode value) {
                return new DefaultScope(value);
            }

            @Override
            protected ScopeCode unwrap(Scope container) {
                return container.getLevel();
            }

            @Override
            protected boolean update(Scope container, ScopeCode value) {
                if (container instanceof DefaultScope) {
                    ((DefaultScope)container).setLevel(value);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setUpdateScopes(Collection<? extends ScopeCode> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceScopes));
        ((LegacyPropertyAdapter)this.getUpdateScopes()).setValues(newValues);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMaintenanceScopes"})
    @XmlElement(name="updateScopeDescription", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeDescription> getUpdateScopeDescriptions() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<ScopeDescription, Scope>(this.getMaintenanceScopes()){

            @Override
            protected Scope wrap(ScopeDescription value) {
                DefaultScope container = new DefaultScope();
                container.setLevelDescription(CollectionsExt.singletonOrEmpty(value));
                return container;
            }

            @Override
            protected ScopeDescription unwrap(Scope container) {
                return 2.getSingleton(container.getLevelDescription(), ScopeDescription.class, this, DefaultMaintenanceInformation.class, "getUpdateScopeDescriptions");
            }

            @Override
            protected boolean update(Scope container, ScopeDescription value) {
                if (container instanceof DefaultScope) {
                    ((DefaultScope)container).setLevelDescription(CollectionsExt.singletonOrEmpty(value));
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setUpdateScopeDescriptions(Collection<? extends ScopeDescription> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.maintenanceScopes));
        ((LegacyPropertyAdapter)this.getUpdateScopeDescriptions()).setValues(newValues);
    }

    @XmlElement(name="maintenanceNote")
    public Collection<InternationalString> getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return this.maintenanceNotes;
    }

    public void setMaintenanceNotes(Collection<? extends InternationalString> newValues) {
        this.maintenanceNotes = this.writeCollection(newValues, this.maintenanceNotes, InternationalString.class);
    }

    @XmlElement(name="contact")
    public Collection<Responsibility> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, Responsibility.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends Responsibility> newValues) {
        this.contacts = this.writeCollection(newValues, this.contacts, Responsibility.class);
    }

    @XmlElement(name="maintenanceDate")
    private Collection<CitationDate> getMaintenanceDate() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMaintenanceDates() : null;
    }

    @XmlElement(name="maintenanceScope")
    private Collection<Scope> getMaintenanceScope() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMaintenanceScopes() : null;
    }
}

