/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.quality.Description;
import org.opengis.util.InternationalString;

@XmlType(name="DQM_Description_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"textDescription", "extendedDescription"})
@XmlRootElement(name="DQM_Description", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
public class DefaultMeasureDescription
extends ISOMetadata
implements Description {
    private static final long serialVersionUID = 4878784271547209576L;
    private InternationalString textDescription;
    private BrowseGraphic extendedDescription;

    public DefaultMeasureDescription() {
    }

    public DefaultMeasureDescription(CharSequence text) {
        this.textDescription = Types.toInternationalString(text);
    }

    public DefaultMeasureDescription(Description object) {
        super(object);
        if (object != null) {
            this.textDescription = object.getTextDescription();
            this.extendedDescription = object.getExtendedDescription();
        }
    }

    public static DefaultMeasureDescription castOrCopy(Description object) {
        if (object == null || object instanceof DefaultMeasureDescription) {
            return (DefaultMeasureDescription)object;
        }
        return new DefaultMeasureDescription(object);
    }

    @Override
    @XmlElement(name="textDescription", required=true)
    public InternationalString getTextDescription() {
        return this.textDescription;
    }

    public void setTextDescription(InternationalString newValue) {
        this.checkWritePermission(this.textDescription);
        this.textDescription = newValue;
    }

    @Override
    @XmlElement(name="extendedDescription")
    public BrowseGraphic getExtendedDescription() {
        return this.extendedDescription;
    }

    public void setExtendedDescription(BrowseGraphic newValue) {
        this.checkWritePermission(this.extendedDescription);
        this.extendedDescription = newValue;
    }
}

