/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.ParameterValueList;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@XmlType(name="ParameterValueGroupType", propOrder={"values", "descriptor"})
@XmlRootElement(name="ParameterValueGroup")
public class DefaultParameterValueGroup
extends Parameters
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -1985309386356545126L;
    private ParameterValueList values;

    public DefaultParameterValueGroup(ParameterDescriptorGroup descriptor) {
        ArgumentChecks.ensureNonNull("descriptor", descriptor);
        this.values = new ParameterValueList(descriptor);
    }

    public DefaultParameterValueGroup(ParameterValueGroup parameters) {
        ArgumentChecks.ensureNonNull("parameters", parameters);
        this.values = new ParameterValueList(parameters.getDescriptor());
        this.values.addAll(parameters.values());
    }

    @Override
    boolean isKnownImplementation() {
        return this.getClass() == DefaultParameterValueGroup.class;
    }

    @Override
    @XmlElement(name="group")
    public ParameterDescriptorGroup getDescriptor() {
        return this.values != null ? this.values.descriptor : null;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    public <T> ParameterValue<T> getOrCreate(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        ParameterValueList values = this.values;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (values.descriptor(i) != parameter) continue;
            return DefaultParameterValueGroup.cast((ParameterValue)values.get(i), parameter.getValueClass());
        }
        return super.getOrCreate(parameter);
    }

    @Override
    final ParameterValue<?> getParameter(ParameterDescriptor<?> parameter) throws ParameterNotFoundException {
        ParameterValueList values = this.values;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (values.descriptor(i) != parameter) continue;
            return (ParameterValue)values.get(i);
        }
        return super.getParameter(parameter);
    }

    @Override
    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", name);
        GeneralParameterValue value = this.parameterIfExist(name);
        if (value == null) {
            GeneralParameterDescriptor descriptor = this.values.descriptor.descriptor(name);
            if (!(descriptor instanceof ParameterDescriptor) || descriptor.getMaximumOccurs() == 0) {
                throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(this.values.descriptor), name), name);
            }
            value = ((ParameterDescriptor)descriptor).createValue();
            this.values.addUnchecked(value);
        }
        return value;
    }

    @Override
    ParameterValue<?> parameterIfExist(String name) throws ParameterNotFoundException {
        GeneralParameterDescriptor d2;
        ParameterValueList values = this.values;
        int index = -1;
        int ambiguity = -1;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            GeneralParameterDescriptor descriptor = values.descriptor(i);
            if (!(descriptor instanceof ParameterDescriptor) || !IdentifiedObjects.isHeuristicMatchForName(descriptor, name)) continue;
            if (index < 0) {
                index = i;
                continue;
            }
            ambiguity = i;
        }
        if (ambiguity < 0) {
            return index >= 0 ? (ParameterValue)values.get(index) : null;
        }
        GeneralParameterDescriptor d1 = values.descriptor(index);
        String message = d1 == (d2 = values.descriptor(ambiguity)) ? Errors.format((short)173, name, index, ambiguity) : Errors.format((short)1, IdentifiedObjects.toString(d1.getName()), IdentifiedObjects.toString(d2.getName()), name);
        throw new ParameterNotFoundException(message, name);
    }

    @Override
    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        ParameterDescriptorGroup descriptor;
        ArgumentChecks.ensureNonNull("name", name);
        ParameterValueList values = this.values;
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(4);
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            GeneralParameterDescriptor descriptor2 = values.descriptor(i);
            if (!(descriptor2 instanceof ParameterDescriptorGroup) || !IdentifiedObjects.isHeuristicMatchForName(descriptor2, name)) continue;
            groups.add((ParameterValueGroup)values.get(i));
        }
        if (groups.isEmpty() && !((descriptor = values.descriptor).descriptor(name) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(descriptor), name), name);
        }
        return groups;
    }

    @Override
    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        ParameterValueList values = this.values;
        ParameterDescriptorGroup descriptor = values.descriptor;
        GeneralParameterDescriptor child = descriptor.descriptor(name);
        if (!(child instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, descriptor.getName(), name), name);
        }
        ParameterValueGroup value = ((ParameterDescriptorGroup)child).createValue();
        values.add(value);
        return value;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (mode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValueGroup that = (DefaultParameterValueGroup)object;
                    return Objects.equals(this.values.descriptor, that.values.descriptor) && Objects.equals(this.values, that.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                return DefaultParameterValueGroup.equals(this, (ParameterValueGroup)object, mode);
            }
        }
        return false;
    }

    static boolean equals(Parameters expected, ParameterValueGroup actual, ComparisonMode mode) {
        if (!Utilities.deepEquals(expected.getDescriptor(), actual.getDescriptor(), mode)) {
            return false;
        }
        if (!mode.isIgnoringMetadata()) {
            return Utilities.deepEquals(expected.values(), actual.values(), mode);
        }
        LinkedList<GeneralParameterValue> values = new LinkedList<GeneralParameterValue>(expected.values());
        block0: for (GeneralParameterValue param : actual.values()) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                if (!Utilities.deepEquals(it.next(), param, mode)) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return values.isEmpty();
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.values.descriptor.hashCode() ^ this.values.hashCode();
    }

    @Override
    public DefaultParameterValueGroup clone() {
        DefaultParameterValueGroup copy = (DefaultParameterValueGroup)super.clone();
        copy.values = new ParameterValueList(copy.values);
        return copy;
    }

    private DefaultParameterValueGroup() {
    }

    private void setDescriptor(ParameterDescriptorGroup descriptor) {
        if (this.values == null) {
            this.values = new ParameterValueList(descriptor);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultParameterValue.class, "setDescriptor", "group");
        }
    }

    @XmlElement(name="parameterValue", required=true)
    private GeneralParameterValue[] getValues() {
        return (GeneralParameterValue[])this.values().toArray(GeneralParameterValue[]::new);
    }

    private void setValues(GeneralParameterValue[] parameters) {
        ParameterValueList addTo = this.values;
        if (addTo == null) {
            addTo = new ParameterValueList(new DefaultParameterDescriptorGroup());
        }
        IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
        ((DefaultParameterDescriptorGroup)addTo.descriptor).merge(DefaultParameterValueGroup.getDescriptors(parameters), replacements);
        addTo.clear();
        this.setValues(parameters, replacements, addTo);
    }

    private void setValues(GeneralParameterValue[] parameters, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements, ParameterValueList addTo) {
        if (parameters == null) {
            parameters = this.values.toArray();
        }
        for (GeneralParameterValue p : parameters) {
            GeneralParameterDescriptor replacement = replacements.get(p.getDescriptor());
            if (replacement != null) {
                if (p instanceof DefaultParameterValue) {
                    ((DefaultParameterValue)p).setDescriptor((ParameterDescriptor)replacement);
                } else if (p instanceof DefaultParameterValueGroup) {
                    ((DefaultParameterValueGroup)p).setValues(null, replacements, new ParameterValueList((ParameterDescriptorGroup)replacement));
                }
            }
            addTo.add(p);
        }
        this.values = addTo;
    }
}

