/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.UseLegacyMetadata;
import org.apache.sis.internal.jaxb.referencing.Code;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NameIterator;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.PropertiesConverter;
import org.apache.sis.referencing.SubTypes;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

@XmlType(name="IdentifiedObjectType", propOrder={"description", "identifier", "names", "remarks"})
@XmlSeeAlso(value={AbstractCRS.class, AbstractDatum.class, DefaultEllipsoid.class, DefaultPrimeMeridian.class, AbstractCS.class})
@UseLegacyMetadata
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
Formattable,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final String LOCALE_KEY = "locale";
    public static final String DEPRECATED_KEY = "deprecated";
    private Identifier name;
    private Collection<GenericName> alias;
    private Set<Identifier> identifiers;
    private InternationalString remarks;
    private final boolean deprecated;
    private transient int hashCode;

    public AbstractIdentifiedObject(Map<String, ?> properties) throws IllegalArgumentException {
        GenericName[] names;
        ArgumentChecks.ensureNonNull("properties", properties);
        Object value = properties.get("name");
        if (value == null || value instanceof String) {
            if (value == null && properties.get("code") == null) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)89, "name"));
            }
            this.name = new NamedIdentifier(PropertiesConverter.convert(properties));
        } else if (value instanceof Identifier) {
            this.name = (Identifier)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "name", value);
        }
        value = properties.get("alias");
        try {
            DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            names = factory.toGenericNames(value);
        }
        catch (ClassCastException e) {
            throw (IllegalArgumentException)AbstractIdentifiedObject.illegalPropertyType(properties, "alias", value).initCause(e);
        }
        this.alias = CollectionsExt.immutableSet(true, names);
        value = properties.get("identifiers");
        if (value == null) {
            this.identifiers = null;
        } else if (value instanceof Identifier) {
            this.identifiers = Collections.singleton((Identifier)value);
        } else if (value instanceof Identifier[]) {
            this.identifiers = CollectionsExt.immutableSet(true, (Identifier[])value);
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "identifiers", value);
        }
        this.remarks = Types.toInternationalString(properties, "remarks");
        value = properties.get(DEPRECATED_KEY);
        if (value == null) {
            this.deprecated = false;
        } else if (value instanceof Boolean) {
            this.deprecated = (Boolean)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, DEPRECATED_KEY, value);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> properties, String key, Object value) {
        return new IllegalArgumentException(Errors.getResources(properties).getString((short)58, key, value.getClass()));
    }

    protected AbstractIdentifiedObject(IdentifiedObject object) {
        ArgumentChecks.ensureNonNull("object", object);
        this.name = object.getName();
        this.alias = CollectionsExt.nonEmpty(object.getAlias());
        this.identifiers = CollectionsExt.nonEmpty(object.getIdentifiers());
        this.remarks = object.getRemarks();
        this.deprecated = object instanceof Deprecable ? ((Deprecable)((Object)object)).isDeprecated() : false;
    }

    public static AbstractIdentifiedObject castOrCopy(IdentifiedObject object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends IdentifiedObject> getInterface() {
        return IdentifiedObject.class;
    }

    @Override
    public Identifier getName() {
        return this.name;
    }

    @Override
    public Collection<GenericName> getAlias() {
        return CollectionsExt.nonNull(this.alias);
    }

    @Override
    public Set<Identifier> getIdentifiers() {
        return CollectionsExt.nonNull(this.identifiers);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.name != null ? this.name.getDescription() : null;
    }

    @Override
    @XmlElement(name="remarks")
    public InternationalString getRemarks() {
        return this.remarks;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName(this.name, this.alias, name, NameToIdentifier.Simplifier.DEFAULT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == null) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                int oc;
                int tc;
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AbstractIdentifiedObject that = (AbstractIdentifiedObject)object;
                if (mode == ComparisonMode.STRICT && (tc = this.hashCode) != 0 && (oc = that.hashCode) != 0 && tc != oc) {
                    return false;
                }
                return Objects.equals(this.name, that.name) && CollectionsExt.nonNull(this.alias).equals(CollectionsExt.nonNull(that.alias)) && CollectionsExt.nonNull(this.identifiers).equals(CollectionsExt.nonNull(that.identifiers)) && Objects.equals(this.remarks, that.remarks);
            }
            case BY_CONTRACT: {
                if (!this.implementsSameInterface(object)) {
                    return false;
                }
                IdentifiedObject that = (IdentifiedObject)object;
                return Utilities.deepEquals(this.getName(), that.getName(), mode) && Utilities.deepEquals(this.getAlias(), that.getAlias(), mode) && Utilities.deepEquals(this.getIdentifiers(), that.getIdentifiers(), mode) && Utilities.deepEquals(this.getRemarks(), that.getRemarks(), mode);
            }
            case IGNORE_METADATA: 
            case APPROXIMATE: 
            case ALLOW_VARIANT: 
            case DEBUG: {
                return this.implementsSameInterface(object);
            }
        }
        throw new IllegalArgumentException(Errors.format((short)146, ComparisonMode.class, (Object)mode));
    }

    private boolean implementsSameInterface(Object object) {
        Class<? extends IdentifiedObject>[] t2;
        Class<? extends IdentifiedObject> type = this.getInterface();
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface() == type;
        }
        return type.isInstance(object) && (t2 = Classes.getLeafInterfaces(object.getClass(), type)).length == 1 && t2[0] == type;
    }

    @Override
    public final boolean equals(Object object) {
        boolean eq = this.equals(object, ComparisonMode.STRICT);
        assert (!eq || this.hashCode() == object.hashCode()) : this;
        return eq;
    }

    public final int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = Long.hashCode(this.computeHashCode());
            if (hash == 0) {
                hash = -1;
            }
            this.hashCode = hash;
        }
        assert (hash == -1 || hash == Long.hashCode(this.computeHashCode())) : hash;
        return hash;
    }

    protected long computeHashCode() {
        return Objects.hash(this.name, CollectionsExt.nonNull(this.alias), CollectionsExt.nonNull(this.identifiers), this.remarks) ^ this.getInterface().hashCode();
    }

    @Override
    protected String formatTo(org.apache.sis.io.wkt.Formatter formatter) {
        WKTUtilities.appendName(this, formatter, ElementKind.forType(this.getClass()));
        return null;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String value = (flags & 4) != 0 ? IdentifiedObjects.getIdentifierOrName(this) : IdentifiedObjects.getDisplayName(this, formatter.locale());
        Strings.formatTo(formatter, flags, width, precision, value);
    }

    AbstractIdentifiedObject() {
        this.deprecated = false;
    }

    @XmlID
    @XmlSchemaType(name="ID")
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml/3.2", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    final String getID() {
        return NameIterator.getID(Context.current(), this, this.name, this.alias, this.identifiers);
    }

    private void setID(String id) {
        Context context = Context.current();
        if (!Context.setObjectForID(context, this, id)) {
            Context.warningOccured(context, this.getClass(), "setID", Errors.class, (short)25, id);
        }
    }

    @XmlElement(required=true)
    final Code getIdentifier() {
        return Code.forIdentifiedObject(this.getClass(), this.identifiers);
    }

    private void setIdentifier(Code identifier) {
        if (this.identifiers == null) {
            Identifier id;
            if (identifier != null && (id = identifier.getIdentifier()) != null) {
                this.identifiers = Collections.singleton(id);
            }
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractIdentifiedObject.class, "setIdentifier", "identifier");
        }
    }

    @XmlElement(name="name", required=true)
    final Collection<Identifier> getNames() {
        return new Names();
    }

    private void setRemarks(InternationalString value) {
        if (this.remarks == null) {
            this.remarks = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractIdentifiedObject.class, "setRemarks", "remarks");
        }
    }

    private final class Names
    extends AbstractCollection<Identifier> {
        private Names() {
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return NameIterator.count(AbstractIdentifiedObject.this);
        }

        @Override
        public Iterator<Identifier> iterator() {
            return new NameIterator(AbstractIdentifiedObject.this);
        }

        @Override
        public boolean add(Identifier id) {
            if (NameIterator.isUnnamed(AbstractIdentifiedObject.this.name)) {
                AbstractIdentifiedObject.this.name = id;
            } else {
                GenericName n;
                GenericName genericName = n = id instanceof GenericName ? (GenericName)((Object)id) : new NamedIdentifier(id);
                if (AbstractIdentifiedObject.this.alias == null) {
                    AbstractIdentifiedObject.this.alias = Collections.singleton(n);
                } else {
                    int size = AbstractIdentifiedObject.this.alias.size();
                    GenericName[] names = AbstractIdentifiedObject.this.alias.toArray(new GenericName[size + 1]);
                    names[size] = n;
                    AbstractIdentifiedObject.this.alias = UnmodifiableArrayList.wrap(names);
                }
            }
            return true;
        }
    }
}

