/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Map;
import org.apache.sis.internal.referencing.provider.NorthPoleRotation;
import org.apache.sis.internal.referencing.provider.SouthPoleRotation;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class PoleRotation
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -8355693495724373931L;
    private static final int POLE_LATITUDE = 0;
    private static final int POLE_LONGITUDE = 1;
    private static final int AXIS_ANGLE = 2;
    private static final double MAX_AXIS_ROTATION = 90.0;
    private final ContextualParameters context;
    private final double sin\u03c6p;
    private final double cos\u03c6p;
    private MathTransform2D inverse;

    private PoleRotation(PoleRotation forward) {
        this.context = forward.context.inverse(forward.context.getDescriptor(), PoleRotation::inverseParameter);
        this.sin\u03c6p = forward.sin\u03c6p;
        this.cos\u03c6p = -forward.cos\u03c6p;
        this.inverse = forward;
    }

    private static boolean inverseParameter(Parameters forward, ParameterValue<?> target) {
        ParameterDescriptorGroup descriptor = forward.getDescriptor();
        int i = descriptor.descriptors().indexOf(target.getDescriptor());
        if (i < 0) {
            return false;
        }
        if (i != 0) {
            i = 3 - i;
        }
        Number value = PoleRotation.getValue(forward, i);
        if (i != 0 && SouthPoleRotation.PARAMETERS.equals(descriptor)) {
            double \u03bbp = value.doubleValue();
            value = Math.copySign(180.0, \u03bbp) - \u03bbp;
        }
        target.setValue(value);
        return true;
    }

    private static Number getValue(Parameters context, int index) {
        return (Number)((ParameterValue)context.values().get(index)).getValue();
    }

    private void setValue(int index, double value) {
        ParameterDescriptor p = (ParameterDescriptor)this.context.getDescriptor().descriptors().get(index);
        this.context.parameter(p.getName().getCode()).setValue(value);
    }

    protected PoleRotation(boolean south, double \u03c6p, double \u03bbp, double \u03b8p) {
        this.context = new ContextualParameters(south ? SouthPoleRotation.PARAMETERS : NorthPoleRotation.PARAMETERS, 2, 2);
        this.setValue(0, \u03c6p);
        this.setValue(1, \u03bbp);
        this.setValue(2, \u03b8p);
        if (south) {
            \u03b8p = -\u03b8p;
        } else {
            \u03c6p = -\u03c6p;
            \u03bbp -= Math.copySign(180.0, \u03bbp);
        }
        double sign = 1.0;
        if (Math.abs(\u03b8p) > 90.0) {
            sign = -1.0;
            \u03b8p -= Math.copySign(180.0, \u03b8p);
            this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertAfter(0, -1, null);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(1, -1, null);
        }
        double \u03c6 = Math.toRadians(\u03c6p);
        this.sin\u03c6p = Math.sin(\u03c6) * sign;
        this.cos\u03c6p = Math.cos(\u03c6) * sign;
        this.context.normalizeGeographicInputs(\u03bbp);
        this.context.denormalizeGeographicOutputs(\u03b8p);
    }

    public static MathTransform rotateSouthPole(MathTransformFactory factory, double \u03c6p, double \u03bbp, double \u03b8p) throws FactoryException {
        PoleRotation kernel = new PoleRotation(true, \u03c6p, \u03bbp, \u03b8p);
        return kernel.context.completeTransform(factory, kernel);
    }

    public static MathTransform rotateNorthPole(MathTransformFactory factory, double \u03c6p, double \u03bbp, double \u03b8p) throws FactoryException {
        PoleRotation kernel = new PoleRotation(false, \u03c6p, \u03bbp, \u03b8p);
        return kernel.context.completeTransform(factory, kernel);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ImmutableIdentifier name = new ImmutableIdentifier(Citations.SIS, "SIS", "Rotated Latitude/longitude (radians domain)");
        return new DefaultParameterDescriptorGroup(Map.of("name", name), 1, 1, (ParameterDescriptor)this.context.getDescriptor().descriptors().get(0));
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = this.getParameterDescriptors().createValue();
        values.values().add(this.context.values().get(0));
        return values;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double z = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double x = cos\u03c6 * cos\u03bb;
        double y = cos\u03c6 * sin\u03bb;
        double y2 = y * y;
        double xsin\u03c6p = x * this.sin\u03c6p;
        double xcos\u03c6p = x * this.cos\u03c6p;
        double zsin\u03c6p = z * this.sin\u03c6p;
        double zcos\u03c6p = z * this.cos\u03c6p;
        double xt = zcos\u03c6p - xsin\u03c6p;
        double zt = -xcos\u03c6p - zsin\u03c6p;
        if (dstPts != null) {
            dstPts[dstOff] = Math.atan2(y, xt);
            dstPts[dstOff + 1] = Math.asin(zt);
        }
        if (!derivate) {
            return null;
        }
        double r2 = xt * xt + y2;
        double zr = Math.sqrt(1.0 - zt * zt);
        double dx\u03c6 = cos\u03bb * zsin\u03c6p + cos\u03c6 * this.cos\u03c6p;
        double dy\u03c6 = cos\u03bb * zcos\u03c6p - cos\u03c6 * this.sin\u03c6p;
        return new Matrix2((xt * x - y2 * this.sin\u03c6p) / r2, -(xt * z * sin\u03bb + y * dx\u03c6) / r2, y * this.cos\u03c6p / zr, dy\u03c6 / zr);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts == dstPts && srcOff < dstOff || this.getClass() != PoleRotation.class) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            return;
        }
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff++];
            double \u03c6 = srcPts[srcOff++];
            double z = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double y = Math.sin(\u03bb) * cos\u03c6;
            double x = Math.cos(\u03bb) * cos\u03c6;
            double xt = this.cos\u03c6p * z - this.sin\u03c6p * x;
            double zt = -this.cos\u03c6p * x - this.sin\u03c6p * z;
            dstPts[dstOff++] = Math.atan2(y, xt);
            dstPts[dstOff++] = Math.asin(zt);
        }
    }

    @Override
    public synchronized MathTransform2D inverse() {
        if (this.inverse == null) {
            PoleRotation simple = new PoleRotation(this);
            ContextualParameters inverseParameters = simple.context;
            double \u03b8p = inverseParameters.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).getElement(0, 2);
            if (Math.abs(\u03b8p) > 90.0) {
                PoleRotation alternative = new PoleRotation(SouthPoleRotation.PARAMETERS.equals(inverseParameters.getDescriptor()), PoleRotation.getValue(inverseParameters, 0).doubleValue(), PoleRotation.getValue(inverseParameters, 1).doubleValue(), PoleRotation.getValue(inverseParameters, 2).doubleValue());
                ContextualParameters actualParameters = alternative.context;
                this.inverse = MathTransforms.concatenate(PoleRotation.concatenate(inverseParameters, ContextualParameters.MatrixRole.INVERSE_NORMALIZATION, actualParameters, ContextualParameters.MatrixRole.NORMALIZATION), alternative, PoleRotation.concatenate(actualParameters, ContextualParameters.MatrixRole.DENORMALIZATION, inverseParameters, ContextualParameters.MatrixRole.INVERSE_DENORMALIZATION));
            } else {
                this.inverse = simple;
            }
        }
        return this.inverse;
    }

    private static MathTransform2D concatenate(ContextualParameters p1, ContextualParameters.MatrixRole r1, ContextualParameters p2, ContextualParameters.MatrixRole r2) {
        return (MathTransform2D)((Object)MathTransforms.linear(p2.getMatrix(r2).multiply(p1.getMatrix(r1))));
    }

    @Override
    public boolean isIdentity() {
        return this.sin\u03c6p == -1.0;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            PoleRotation other = (PoleRotation)object;
            if (mode.isApproximate()) {
                return Numerics.epsilonEqual(this.sin\u03c6p, other.sin\u03c6p, 1.5706706731410455E-9) && Numerics.epsilonEqual(this.cos\u03c6p, other.cos\u03c6p, 1.5706706731410455E-9);
            }
            return Numerics.equals(this.sin\u03c6p, other.sin\u03c6p) && Numerics.equals(this.cos\u03c6p, other.cos\u03c6p);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Double.hashCode(this.cos\u03c6p) + Double.hashCode(this.sin\u03c6p);
    }
}

