/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public abstract class AbstractName
implements GenericName,
Serializable {
    private static final long serialVersionUID = 667242702456713391L;
    transient GenericName fullyQualified;
    transient CharSequence asString;
    private transient int hash;

    protected AbstractName() {
    }

    public static AbstractName castOrCopy(GenericName object) {
        if (object instanceof LocalName) {
            return DefaultLocalName.castOrCopy((LocalName)object);
        }
        if (object == null || object instanceof AbstractName) {
            return (AbstractName)object;
        }
        List<? extends LocalName> parsedNames = object.getParsedNames();
        CharSequence[] names = new CharSequence[parsedNames.size()];
        int i = 0;
        for (LocalName localName : parsedNames) {
            names[i++] = localName.toInternationalString();
        }
        if (i != names.length) {
            throw new ConcurrentModificationException(Errors.format((short)134, "parsedNames"));
        }
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return (AbstractName)factory.createGenericName(object.scope(), names);
    }

    @Override
    public abstract NameSpace scope();

    @Override
    public int depth() {
        return this.getParsedNames().size();
    }

    int arraySize() {
        return this.depth();
    }

    @Override
    public abstract List<? extends LocalName> getParsedNames();

    @Override
    public LocalName head() {
        return this.getParsedNames().get(0);
    }

    @Override
    public LocalName tip() {
        List<? extends LocalName> names = this.getParsedNames();
        return names.get(names.size() - 1);
    }

    @Override
    public synchronized GenericName toFullyQualifiedName() {
        if (this.fullyQualified == null) {
            NameSpace scope = this.scope();
            if (scope.isGlobal()) {
                this.fullyQualified = this;
            } else {
                GenericName prefix = scope.name();
                assert (prefix.scope().isGlobal()) : prefix;
                this.fullyQualified = new DefaultScopedName(prefix, this);
            }
        }
        return this.fullyQualified;
    }

    @Override
    public ScopedName push(GenericName scope) {
        return new DefaultScopedName(scope, this);
    }

    private static String headSeparator(GenericName name) {
        return name != null ? DefaultNameSpace.getSeparator(name.scope(), true) : ":";
    }

    @Override
    public synchronized String toString() {
        if (this.asString == null) {
            boolean insertSeparator = false;
            StringBuilder buffer = new StringBuilder();
            for (LocalName localName : this.getParsedNames()) {
                if (insertSeparator) {
                    buffer.append(AbstractName.headSeparator(localName));
                }
                insertSeparator = true;
                buffer.append(localName);
            }
            this.asString = buffer.toString();
        }
        return this.asString.toString();
    }

    @Override
    public synchronized InternationalString toInternationalString() {
        if (!(this.asString instanceof InternationalString)) {
            this.asString = new International(this.toString(), this.getParsedNames());
        }
        return (InternationalString)this.asString;
    }

    @Override
    public int compareTo(GenericName name) {
        Iterator<? extends LocalName> thisNames = this.getParsedNames().iterator();
        Iterator<? extends LocalName> thatNames = name.getParsedNames().iterator();
        while (thisNames.hasNext()) {
            if (!thatNames.hasNext()) {
                return 1;
            }
            LocalName thisNext = thisNames.next();
            LocalName thatNext = thatNames.next();
            if (thisNext == this && thatNext == name) {
                throw new IllegalStateException(Errors.format((short)18));
            }
            int compare = thisNext.compareTo(thatNext);
            if (compare == 0) continue;
            return compare;
        }
        return thatNames.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AbstractName that = (AbstractName)object;
            return Objects.equals(this.scope(), that.scope()) && Objects.equals(this.getParsedNames(), that.getParsedNames());
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int code = this.computeHashCode();
            if (code == 0) {
                code = -1;
            }
            this.hash = code;
        }
        return this.hash;
    }

    int computeHashCode() {
        return Objects.hash(this.scope(), this.getParsedNames()) ^ 0xE2E770AF;
    }

    private static final class International
    extends SimpleInternationalString {
        private static final long serialVersionUID = -5259001179796274879L;
        private final List<? extends LocalName> parsedNames;

        International(String asString, List<? extends LocalName> parsedNames) {
            super(asString);
            this.parsedNames = parsedNames;
        }

        @Override
        public String toString(Locale locale) {
            boolean insertSeparator = false;
            StringBuilder buffer = new StringBuilder();
            for (LocalName localName : this.parsedNames) {
                if (insertSeparator) {
                    buffer.append(AbstractName.headSeparator(localName));
                }
                insertSeparator = true;
                buffer.append(localName.toInternationalString().toString(locale));
            }
            return buffer.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (super.equals(object)) {
                International that = (International)object;
                return Objects.equals(this.parsedNames, that.parsedNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.parsedNames.hashCode() ^ 0x54E20141;
        }
    }
}

