/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.display.shape.ProjectedPathIterator;
import org.geotoolkit.display.shape.TransformedShape;
import org.geotoolkit.display.shape.XRectangle2D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ProjectedShape
implements Shape,
Serializable {
    private static final long serialVersionUID = -583674918489345612L;
    protected final Shape shape;
    protected final MathTransform2D projection;
    private transient MathTransform2D inverse;
    private transient Point2D.Double point;
    private transient Rectangle2D.Double rectangle;

    protected ProjectedShape(Shape shape, MathTransform2D projection) {
        ArgumentChecks.ensureNonNull("shape", shape);
        ArgumentChecks.ensureNonNull("projection", projection);
        this.shape = shape;
        this.projection = projection;
    }

    public static Shape wrap(Shape shape, MathTransform2D projection) {
        if (projection == null || projection.isIdentity()) {
            return shape;
        }
        if (projection instanceof AffineTransform) {
            return new TransformedShape(shape, (AffineTransform)((Object)projection));
        }
        return new ProjectedShape(shape, projection);
    }

    private MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = this.projection.inverse();
            if (this.point == null) {
                this.point = new Point2D.Double();
            }
            if (this.rectangle == null) {
                this.rectangle = new Rectangle2D.Double();
            }
        }
        return this.inverse;
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D.Double p = this.point;
        if (p == null) {
            this.point = p = new Point2D.Double();
        }
        p.x = x;
        p.y = y;
        return this.contains(p);
    }

    @Override
    public boolean contains(Point2D p) {
        try {
            return this.shape.contains(this.inverse().transform(p, this.point));
        }
        catch (TransformException exception) {
            Logging.recoverableException(null, ProjectedShape.class, "contains", exception);
            return false;
        }
    }

    @Override
    public boolean contains(double x, double y, double width, double height) {
        Rectangle2D.Double r = this.rectangle;
        if (r == null) {
            this.rectangle = r = new Rectangle2D.Double();
        }
        r.x = x;
        r.y = y;
        r.width = width;
        r.height = height;
        return this.contains(r);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        try {
            return this.shape.contains(Shapes2D.transform(this.inverse(), r, (Rectangle2D)this.rectangle));
        }
        catch (TransformException exception) {
            Logging.recoverableException(null, ProjectedShape.class, "contains", exception);
            return false;
        }
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        Rectangle2D.Double r = this.rectangle;
        if (r == null) {
            this.rectangle = r = new Rectangle2D.Double();
        }
        r.x = x;
        r.y = y;
        r.width = width;
        r.height = height;
        return this.intersects(r);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        try {
            return this.shape.intersects(Shapes2D.transform(this.inverse(), r, (Rectangle2D)this.rectangle));
        }
        catch (TransformException exception) {
            Logging.recoverableException(null, ProjectedShape.class, "intersects", exception);
            return true;
        }
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = new Rectangle();
        bounds.setRect(bounds);
        return bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        try {
            return Shapes2D.transform(this.projection, this.shape.getBounds2D(), null);
        }
        catch (TransformException exception) {
            Logging.recoverableException(null, ProjectedShape.class, "getBounds2D", exception);
            return XRectangle2D.INFINITY;
        }
    }

    private MathTransform2D concatenate(AffineTransform at) {
        MathTransform2D concatenated = this.projection;
        if (at != null && !at.isIdentity()) {
            concatenated = MathTransforms.concatenate(concatenated, new AffineTransform2D(at));
        }
        return concatenated;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        MathTransform2D concatenated = this.concatenate(at);
        if (concatenated.isIdentity()) {
            return this.shape.getPathIterator(at);
        }
        return new ProjectedPathIterator(this.shape.getPathIterator(null), concatenated);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        MathTransform2D concatenated = this.concatenate(at);
        if (concatenated.isIdentity()) {
            return this.shape.getPathIterator(at, flatness);
        }
        return new FlatteningPathIterator(new ProjectedPathIterator(this.shape.getPathIterator(null), concatenated), flatness);
    }

    public int hashCode() {
        return this.shape.hashCode() ^ this.projection.hashCode() ^ 0xB2331B4;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectedShape) {
            ProjectedShape other = (ProjectedShape)object;
            return this.shape.equals(other.shape) && this.projection.equals(other.projection);
        }
        return false;
    }
}

