/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.aggregate;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.aggregate.Aggregate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractJTSAggregate<T extends Geometry>
extends AbstractJTSGeometry
implements Aggregate {
    private Set<T> elements = new LinkedHashSet<T>();

    public AbstractJTSAggregate() {
    }

    public AbstractJTSAggregate(CoordinateReferenceSystem crs) {
        super(crs);
    }

    @Override
    protected org.locationtech.jts.geom.Geometry computeJTSPeer() {
        CoordinateReferenceSystem crs;
        ArrayList<org.locationtech.jts.geom.Geometry> childParts = new ArrayList<org.locationtech.jts.geom.Geometry>();
        for (Geometry prim : this.elements) {
            if (prim instanceof JTSGeometry) {
                JTSGeometry jtsGeom = (JTSGeometry)((Object)prim);
                org.locationtech.jts.geom.Geometry geom = jtsGeom.getJTSGeometry();
                if (geom == null) continue;
                childParts.add(geom);
                continue;
            }
            throw new IllegalStateException("Only JTSGeometries are allowed in the JTSAggregate class.");
        }
        org.locationtech.jts.geom.Geometry result = null;
        if (childParts.size() == 1) {
            org.locationtech.jts.geom.Geometry geom = (org.locationtech.jts.geom.Geometry)childParts.get(0);
            if (geom instanceof LineString) {
                result = JTSUtils.GEOMETRY_FACTORY.createMultiLineString(new LineString[]{(LineString)geom});
            }
            if (geom instanceof Polygon) {
                result = JTSUtils.GEOMETRY_FACTORY.createMultiPolygon(new Polygon[]{(Polygon)geom});
            }
            if (geom instanceof Point) {
                result = JTSUtils.GEOMETRY_FACTORY.createMultiPoint(new Point[]{(Point)geom});
            }
        }
        if (result == null) {
            result = JTSUtils.GEOMETRY_FACTORY.buildGeometry(childParts);
        }
        if ((crs = this.getCoordinateReferenceSystem()) != null) {
            int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
            result.setSRID(srid);
        }
        return result;
    }

    public Set<T> getElements() {
        return this.elements;
    }

    public void setElements(Set<T> elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("elements:").append('\n');
        for (Geometry g2 : this.elements) {
            sb.append(g2).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractJTSAggregate && super.equals(object)) {
            AbstractJTSAggregate that = (AbstractJTSAggregate)object;
            return Objects.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 41 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }
}

