/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry;

import org.apache.sis.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.NotifyingArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSPointArray
extends NotifyingArrayList<Position>
implements PointArray,
JTSGeometry {
    private static final long serialVersionUID = -9202900942004287122L;
    private CoordinateReferenceSystem crs;

    public JTSPointArray() {
        this((CoordinateReferenceSystem)null);
    }

    public JTSPointArray(CoordinateReferenceSystem crs) {
        this(null, crs);
    }

    public JTSPointArray(JTSGeometry parent, CoordinateReferenceSystem crs) {
        super(parent);
        this.crs = crs;
    }

    @Override
    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public Position get(int column) throws IndexOutOfBoundsException {
        return new GeneralDirectPosition((DirectPosition)super.get(column));
    }

    @Override
    public DirectPosition getDirectPosition(int column, DirectPosition dest) throws IndexOutOfBoundsException {
        DirectPosition position = (DirectPosition)this.get(column);
        if (dest == null) {
            dest = position.getCoordinateReferenceSystem() != null ? new GeneralDirectPosition(position.getCoordinateReferenceSystem()) : new GeneralDirectPosition(position.getDimension());
        }
        for (int i = 0; i < position.getDimension(); ++i) {
            dest.setOrdinate(i, position.getOrdinate(i));
        }
        return dest;
    }

    public void setDirectPosition(int column, DirectPosition position) throws IndexOutOfBoundsException {
        DirectPosition thisPosition = (DirectPosition)this.get(column);
        DirectPosition otherPosition = position.getDirectPosition();
        for (int i = 0; i < thisPosition.getDimension(); ++i) {
            thisPosition.setOrdinate(i, otherPosition.getOrdinate(i));
        }
        this.invalidateCachedJTSPeer();
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] result = new DirectPosition[n];
        for (int i = 0; i < n; ++i) {
            result[i] = new GeneralDirectPosition((DirectPosition)this.get(i));
        }
        return result;
    }

    @Override
    public Geometry getJTSGeometry() {
        int n = super.size();
        Coordinate[] coords = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            coords[i] = JTSUtils.directPositionToCoordinate((DirectPosition)super.get(i));
        }
        return JTSUtils.GEOMETRY_FACTORY.createMultiPoint(coords);
    }
}

