/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.internal.sql.DefaultDataSource;

public enum AxisResolve {
    STRICT,
    RIGHT_HANDED,
    AUTO;

    private static final String PROPERTY_KEY = "geotk.gml.axis.resolve";

    public static AxisResolve forName(String name) {
        ArgumentChecks.ensureNonNull("Assessed name", name);
        switch (name.trim().toUpperCase()) {
            case "STRICT": {
                return STRICT;
            }
            case "RIGHT_HANDED": {
                return RIGHT_HANDED;
            }
            case "AUTO": {
                return AUTO;
            }
        }
        throw new IllegalArgumentException("String input " + name + " doesn't match any AxisResolveValue");
    }

    public static AxisResolve getDefault() {
        String confVal = System.getProperty(PROPERTY_KEY, System.getenv("GEOTK_GML_AXIS_RESOLVE"));
        if (confVal == null || (confVal = confVal.trim()).isEmpty()) {
            return STRICT;
        }
        try {
            return AxisResolve.forName(confVal);
        }
        catch (Exception e) {
            DefaultDataSource.LOGGER.log(Level.WARNING, "Unknown axis resolve value: " + confVal);
            return STRICT;
        }
    }

    public static void setDefault(AxisResolve axisResolve) {
        System.setProperty(PROPERTY_KEY, axisResolve.toString());
    }
}

