/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.gml.xml.AbstractFeature;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.v321.AbstractCoverageType;
import org.geotoolkit.gml.xml.v321.AbstractFeatureCollectionType;
import org.geotoolkit.gml.xml.v321.AbstractGMLType;
import org.geotoolkit.gml.xml.v321.BoundedFeatureType;
import org.geotoolkit.gml.xml.v321.BoundingShapeType;
import org.geotoolkit.gml.xml.v321.DynamicFeatureType;
import org.geotoolkit.gml.xml.v321.LocationPropertyType;
import org.geotoolkit.gml.xml.v321.ObjectFactory;
import org.geotoolkit.gml.xml.v321.ObservationType;
import org.geotoolkit.gml.xml.v321.PriorityLocationPropertyType;
import org.geotoolkit.gml.xml.v321.ReferenceType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractFeatureType", propOrder={"boundedBy", "location"})
@XmlSeeAlso(value={ObservationType.class, AbstractFeatureCollectionType.class, AbstractCoverageType.class, DynamicFeatureType.class, BoundedFeatureType.class})
public abstract class AbstractFeatureType
extends AbstractGMLType
implements AbstractFeature {
    @XmlElement(nillable=true)
    private BoundingShapeType boundedBy;
    @XmlElementRef(name="location", namespace="http://www.opengis.net/gml/3.2", type=JAXBElement.class)
    private JAXBElement<? extends LocationPropertyType> location;

    public AbstractFeatureType() {
    }

    public AbstractFeatureType(AbstractFeature af) {
        super(af);
        if (af != null) {
            if (af.getBoundedBy() != null) {
                this.boundedBy = new BoundingShapeType(af.getBoundedBy());
            }
            if (af.getLocation() != null) {
                ObjectFactory factory = new ObjectFactory();
                if (af.getLocation() instanceof LocationPropertyType) {
                    this.location = factory.createLocation((LocationPropertyType)af.getLocation());
                } else if (af.getLocation() instanceof PriorityLocationPropertyType) {
                    this.location = factory.createPriorityLocation((PriorityLocationPropertyType)af.getLocation());
                } else {
                    throw new IllegalArgumentException("LocationProperty clone not implemented yet");
                }
            }
        }
    }

    public AbstractFeatureType(String id, String name, String description) {
        super(id, name, description, null);
    }

    public AbstractFeatureType(String id, String name, String description, ReferenceType descriptionReference, BoundingShapeType boundedBy) {
        super(id, name, description, descriptionReference);
        this.boundedBy = boundedBy;
    }

    @Override
    public BoundingShapeType getBoundedBy() {
        return this.boundedBy;
    }

    public void setBoundedBy(BoundingShapeType value) {
        this.boundedBy = value;
    }

    public void extendBoundingShape(AbstractGeometry newGeom) {
        if (newGeom == null) {
            return;
        }
        if (newGeom instanceof Point) {
            Point pt = (Point)newGeom;
            if (this.boundedBy != null && this.boundedBy.getEnvelope() != null) {
                GeneralEnvelope gEnv = new GeneralEnvelope(this.boundedBy.getEnvelope());
                gEnv.add(pt.getPos());
                this.boundedBy = new BoundingShapeType(gEnv);
            } else {
                GeneralEnvelope gEnv = new GeneralEnvelope(pt.getCoordinateReferenceSystem(true));
                gEnv.setRange(0, pt.getPos().getOrdinate(1), pt.getPos().getOrdinate(1));
                gEnv.setRange(1, pt.getPos().getOrdinate(0), pt.getPos().getOrdinate(0));
                this.boundedBy = new BoundingShapeType(gEnv);
            }
        } else {
            throw new UnsupportedOperationException("extendBoundingShape is only supported for Point");
        }
    }

    public JAXBElement<? extends LocationPropertyType> getjbLocation() {
        return this.location;
    }

    @Override
    public LocationPropertyType getLocation() {
        if (this.location != null) {
            return this.location.getValue();
        }
        return null;
    }

    public void setLocation(JAXBElement<? extends LocationPropertyType> value) {
        this.location = value;
    }

    @Override
    public List<String> getSrsName() {
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append("\n");
        if (this.location != null) {
            sb.append("location:\n").append(this.location.getValue()).append('\n');
        }
        if (this.boundedBy != null) {
            sb.append("boundedBy: ").append(this.boundedBy).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractFeatureType && super.equals(object, mode)) {
            AbstractFeatureType that = (AbstractFeatureType)object;
            boolean loc = false;
            if (this.location != null && that.location != null) {
                loc = Objects.equals(this.location.getValue(), that.location.getValue());
            } else if (this.location == null && that.location == null) {
                loc = true;
            }
            return Objects.equals(this.boundedBy, that.boundedBy) && loc;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + super.hashCode();
        hash = 83 * hash + (this.boundedBy != null ? this.boundedBy.hashCode() : 0);
        hash = 83 * hash + (this.location != null ? this.location.hashCode() : 0);
        return hash;
    }
}

