/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LEDataInputStream
extends InputStream
implements DataInput {
    private final DataInputStream ds;
    private final InputStream in;
    private final byte[] buffer = new byte[8];
    private long position = 0L;

    public LEDataInputStream(InputStream in) {
        this.in = in;
        this.ds = new DataInputStream(in);
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public int available() throws IOException {
        return this.ds.available();
    }

    @Override
    public final short readShort() throws IOException {
        this.position += 2L;
        this.ds.readFully(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    public short[] readShorts(int nbValues) throws IOException {
        short[] array = new short[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.position += 2L;
        this.ds.readFully(this.buffer, 0, 2);
        return (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public int[] readUnsignedShorts(int nbValues) throws IOException {
        int[] array = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readUnsignedShort();
        }
        return array;
    }

    @Override
    public final char readChar() throws IOException {
        this.position += 2L;
        this.ds.readFully(this.buffer, 0, 2);
        return (char)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.position += 4L;
        this.ds.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public int[] readInts(int nbValues) throws IOException {
        int[] array = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    @Override
    public final long readLong() throws IOException {
        this.position += 8L;
        this.ds.readFully(this.buffer, 0, 8);
        return (long)this.buffer[7] << 56 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[0] & 0xFF);
    }

    public long[] readLongs(int nbValues) throws IOException {
        long[] array = new long[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public float[] readFloats(int nbValues) throws IOException {
        float[] array = new float[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public double[] readDoubles(int nbValues) throws IOException {
        double[] array = new double[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int nb = this.in.read(b, off, len);
        this.position += (long)nb;
        return nb;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.ds.readFully(b, 0, b.length);
        this.position += (long)b.length;
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.ds.readFully(b, off, len);
        this.position += (long)len;
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int nb = this.ds.skipBytes(n);
        if (nb <= 0) {
            return nb;
        }
        this.position += (long)nb;
        return nb;
    }

    public final void skipFully(int n) throws IOException {
        while (n > 0) {
            int nb = this.skipBytes(n);
            if (nb == -1) {
                throw new EOFException();
            }
            if (nb == 0) {
                nb = this.read();
                if (nb == -1) {
                    throw new EOFException();
                }
                nb = 1;
            }
            n -= nb;
        }
    }

    @Override
    public final boolean readBoolean() throws IOException {
        ++this.position;
        return this.ds.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        ++this.position;
        return this.ds.readByte();
    }

    @Override
    public int read() throws IOException {
        ++this.position;
        return this.in.read();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        ++this.position;
        return this.ds.readUnsignedByte();
    }

    @Override
    public final String readLine() throws IOException {
        return this.ds.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.ds.readUTF();
    }

    public int realign(int blockSize) throws IOException {
        long position = this.getPosition();
        long res = position % (long)blockSize;
        if (res == 0L) {
            return 0;
        }
        try {
            this.skipFully((int)((long)blockSize - res));
        }
        catch (EOFException ex) {
            return -1;
        }
        return (int)res;
    }

    @Override
    public final void close() throws IOException {
        this.ds.close();
    }

    public static short readUnsignedByte(byte[] buffer, int offset) {
        return (short)(buffer[offset] & 0xFF);
    }

    public static short readShort(byte[] buffer, int offset) {
        return (short)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF);
    }

    public static int readUnsignedShort(byte[] buffer, int offset) {
        return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF;
    }

    public static char readChar(byte[] buffer, int offset) {
        return (char)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF);
    }

    public static int readInt(byte[] buffer, int offset) {
        return buffer[offset + 3] << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset + 0] & 0xFF;
    }

    public static long readUnsignedInt(byte[] buffer, int offset) {
        return (long)(buffer[offset + 3] & 0xFF) << 24 | (long)(buffer[offset + 2] & 0xFF) << 16 | (long)(buffer[offset + 1] & 0xFF) << 8 | (long)(buffer[offset + 0] & 0xFF);
    }

    public static long readLong(byte[] buffer, int offset) {
        return (long)buffer[offset + 7] << 56 | (long)(buffer[offset + 6] & 0xFF) << 48 | (long)(buffer[offset + 5] & 0xFF) << 40 | (long)(buffer[offset + 4] & 0xFF) << 32 | (long)(buffer[offset + 3] & 0xFF) << 24 | (long)(buffer[offset + 2] & 0xFF) << 16 | (long)(buffer[offset + 1] & 0xFF) << 8 | (long)(buffer[offset + 0] & 0xFF);
    }

    public static float readFloat(byte[] buffer, int offset) {
        return Float.intBitsToFloat(LEDataInputStream.readInt(buffer, offset));
    }

    public static double readDouble(byte[] buffer, int offset) {
        return Double.longBitsToDouble(LEDataInputStream.readLong(buffer, offset));
    }
}

