/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.management;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DefaultJMXClient {
    private final JMXConnector connector;
    private final MBeanServerConnection mbsc;

    public DefaultJMXClient(String jmxURL, String user, String password) throws MalformedURLException, IOException {
        this(new JMXServiceURL(jmxURL), user, password);
    }

    public DefaultJMXClient(JMXServiceURL jmxURL, String user, String password) throws IOException {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] credentials = new String[]{user, password};
        env.put("jmx.remote.credentials", credentials);
        this.connector = JMXConnectorFactory.connect(jmxURL, env);
        this.mbsc = this.connector.getMBeanServerConnection();
    }

    public JMXConnector getJMXConnector() {
        return this.connector;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public <T> T getMBean(String name, Class<T> beanClass) throws MalformedObjectNameException {
        ObjectName mbeanName = new ObjectName(name);
        T mbeanProxy = JMX.newMBeanProxy(this.mbsc, mbeanName, beanClass, true);
        return mbeanProxy;
    }

    public void dispose() throws IOException {
        this.connector.close();
    }
}

