/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Line
extends org.apache.sis.math.Line {
    private static final double EPS = 1.0E-12;

    public Line() {
    }

    public Line(double slope, double y0) {
        super(slope, y0);
    }

    public Point2D intersectionPoint(Line line) {
        double y;
        double x;
        if (Double.isInfinite(this.slope())) {
            if (Double.isInfinite(line.slope())) {
                return null;
            }
            x = this.x0();
            y = line.y(x);
        } else {
            if (Double.isInfinite(line.slope())) {
                x = line.x0();
            } else {
                x = (this.y0() - line.y0()) / (line.slope() - this.slope());
                if (Double.isInfinite(x)) {
                    return null;
                }
            }
            y = this.y(x);
        }
        return new Point2D.Double(x, y);
    }

    public Point2D intersectionPoint(Line2D line) {
        double y;
        double x;
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double m4 = (y2 - y1) / (x2 - x1);
        if (Double.isInfinite(this.slope())) {
            x = this.x0();
            y = x * m4 + (y2 - m4 * x2);
        } else {
            x = !Double.isInfinite(m4) ? (this.y0() - (y2 - m4 * x2)) / (m4 - this.slope()) : 0.5 * (x1 + x2);
            y = x * this.slope() + this.y0();
        }
        double eps = 1.0E-12 * Math.abs(x);
        if (x1 <= x2 ? !(x >= x1 - eps) || !(x <= x2 + eps) : !(x <= x1 + eps) || !(x >= x2 - eps)) {
            return null;
        }
        eps = 1.0E-12 * Math.abs(y);
        if (y1 <= y2 ? !(y >= y1 - eps) || !(y <= y2 + eps) : !(y <= y1 - eps) || !(y >= y2 + eps)) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D nearestColinearPoint(Point2D point) {
        if (!Double.isInfinite(this.slope())) {
            double x = ((point.getY() - this.y0()) * this.slope() + point.getX()) / (this.slope() * this.slope() + 1.0);
            return new Point2D.Double(x, x * this.slope() + this.y0());
        }
        return new Point2D.Double(this.x0(), point.getY());
    }

    public Line2D isoscelesTriangleBase(Point2D summit, double sideLength) {
        double A2;
        sideLength *= sideLength;
        if (this.slope() == 0.0) {
            double x = summit.getX();
            double dy = this.y0() - summit.getY();
            double dx = Math.sqrt(sideLength - dy * dy);
            if (Double.isNaN(dx)) {
                return null;
            }
            return new Line2D.Double(x + dx, this.y0(), x - dx, this.y0());
        }
        if (Double.isInfinite(this.slope())) {
            double y = summit.getY();
            double dx = this.x0() - summit.getX();
            double dy = Math.sqrt(sideLength - dx * dx);
            if (Double.isNaN(dy)) {
                return null;
            }
            return new Line2D.Double(this.x0(), y + dy, this.x0(), y - dy);
        }
        double x = summit.getX();
        double y = summit.getY();
        double dy = this.y0() - y + this.slope() * x;
        double B = -this.slope() * dy;
        double C2 = Math.sqrt(B * B + (A2 = this.slope() * this.slope() + 1.0) * (sideLength - dy * dy));
        if (Double.isNaN(C2)) {
            return null;
        }
        double x1 = (B + C2) / A2 + x;
        double x2 = (B - C2) / A2 + x;
        return new Line2D.Double(x1, this.slope() * x1 + this.y0(), x2, this.slope() * x2 + this.y0());
    }
}

