/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30;

import jakarta.ws.rs.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.TestRunArg;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.URIUtils;
import org.opengis.cite.cat30.util.ValidationUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerSchemas(suite);
        this.registerClientComponent(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        this.deleteTempFiles(suite);
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), entityFile);
        Document iutDoc = null;
        try {
            iutDoc = URIUtils.parseURI(entityFile.toURI());
        }
        catch (IOException | SAXException x) {
            throw new RuntimeException("Failed to parse resource retrieved from " + iutRef, x);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), iutDoc);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(iutDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), client);
        }
    }

    void registerSchemas(ISuite suite) {
        Schema atomSchema;
        Schema csw3Schema = ValidationUtils.createCSWSchema();
        if (null != csw3Schema) {
            suite.setAttribute(SuiteAttribute.CSW_SCHEMA.getName(), csw3Schema);
        }
        if (null != (atomSchema = ValidationUtils.createAtomSchema())) {
            suite.setAttribute(SuiteAttribute.ATOM_SCHEMA.getName(), atomSchema);
        }
    }

    void deleteTempFiles(ISuite suite) {
        DatasetInfo dataset;
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
        if (null != (dataset = (DatasetInfo)suite.getAttribute(SuiteAttribute.DATASET.getName()))) {
            File dataFile = dataset.getDataFile();
            dataFile.delete();
        }
    }
}

