/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.util.CSWClient;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OpenSearchDescriptionTests
extends CommonFixture {
    private RelaxNGValidator osdValidator;
    private URI baseUri;
    private static final String SCHEMATRON_OPENSEARCH_DESCR = "/org/opengis/cite/cat30/sch/opensearch-1.1.sch";
    public static final String OPENSEARCH_CONSTRAINT = "OpenSearchDescriptionDocument";

    @BeforeClass
    public void initFixture(ITestContext testContext) {
        URL rncSchema = this.getClass().getResource("/org/opengis/cite/cat30/rnc/osd-1.1-draft5.rnc");
        try {
            this.osdValidator = new RelaxNGValidator(rncSchema);
        }
        catch (IOException | SAXException ex) {
            TestSuiteLogger.log(Level.WARNING, this.getClass().getName(), ex);
        }
        this.baseUri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
    }

    @Test(description="Requirements: 008; Tests: 008")
    public void preferOpenSearchDescription() {
        String xmlNotPreferred = "application/xml; q=0.5";
        this.response = ClientUtils.buildGetRequest(this.baseUri, null, MediaType.valueOf(xmlNotPreferred), MediaType.valueOf("application/opensearchdescription+xml"));
        Assert.assertEquals(this.response.getStatus(), Response.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue(XMLUtils.isXML(this.response.getMediaType()), ErrorMessage.format("NotXML", this.response.getMediaType()));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        QName osdDocElemName = new QName("http://a9.com/-/spec/opensearch/1.1/", "OpenSearchDescription");
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), osdDocElemName);
    }

    @Test(description="Requirements: 021; Tests: 021")
    public void validOpenSearchDescription() throws SAXException, IOException {
        this.response = ClientUtils.buildGetRequest(this.baseUri, null, MediaType.valueOf("application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf("application/opensearchdescription+xml"));
        Assert.assertTrue(XMLUtils.isXML(this.response.getMediaType()), ErrorMessage.format("NotXML", this.response.getMediaType()));
        Source entity = ClientUtils.getResponseEntityAsSource(this.response, null);
        this.osdValidator.validate(entity);
        ValidationErrorHandler err = this.osdValidator.getErrorHandler();
        Assert.assertFalse(err.errorsDetected(), ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
        URL schemaUrl = this.getClass().getResource(SCHEMATRON_OPENSEARCH_DESCR);
        ETSAssert.assertSchematronValid(schemaUrl, entity);
    }

    @Test(description="[CAT-HTTP]: 6.5.6.2, Table 16")
    public void getOpenSearchDescriptionFromCapabilities() {
        URI getCapabilitiesEndpoint = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        CSWClient cswClient = new CSWClient();
        Document capabilitiesDoc = cswClient.getCapabilities(getCapabilitiesEndpoint);
        Assert.assertNotNull(capabilitiesDoc, "Failed to retrieve capabilities document as 'application/xml' from " + getCapabilitiesEndpoint);
        Set<String> values = ServiceMetadataUtils.getConstraintValues(capabilitiesDoc, OPENSEARCH_CONSTRAINT);
        if (null == values || values.isEmpty()) {
            throw new AssertionError((Object)ErrorMessage.format("NamedItemNotFound", OPENSEARCH_CONSTRAINT));
        }
        URI uri = URI.create(values.iterator().next());
        this.response = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf("application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf("application/opensearchdescription+xml"));
        Assert.assertEquals(this.response.getStatus(), Response.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue(XMLUtils.isXML(this.response.getMediaType()), ErrorMessage.format("NotXML", this.response.getMediaType()));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        QName osdDocElemName = new QName("http://a9.com/-/spec/opensearch/1.1/", "OpenSearchDescription");
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), osdDocElemName);
    }
}

