/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.testng.ITestNGMethod;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.IContainer;
import org.testng.log4testng.Logger;

public class ConfigurationGroupMethods {
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Map<String, CountDownLatch> beforeGroupsThatHaveAlreadyRun = new ConcurrentHashMap<String, CountDownLatch>();
    private final Set<String> afterGroupsThatHaveAlreadyRun = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private volatile Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(IContainer<ITestNGMethod> container, Map<String, List<ITestNGMethod>> beforeGroupsMethods, Map<String, List<ITestNGMethod>> afterGroupsMethods) {
        this.m_allMethods = container.getItems();
        this.m_beforeGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(beforeGroupsMethods);
        this.m_afterGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(afterGroupsMethods);
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getBeforeGroupMethodsForGroup(String[] groups) {
        if (groups.length == 0) {
            return Collections.emptyList();
        }
        Map<String, CountDownLatch> map = this.beforeGroupsThatHaveAlreadyRun;
        synchronized (map) {
            return Arrays.stream(groups).map(t2 -> ConfigurationGroupMethods.retrieve(this.beforeGroupsThatHaveAlreadyRun, this.m_beforeGroupsMethods, t2)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getAfterGroupMethods(ITestNGMethod testMethod) {
        if (testMethod.hasMoreInvocation() || testMethod.getGroups().length == 0) {
            return Collections.emptyList();
        }
        HashSet<String> methodGroups = new HashSet<String>(Arrays.asList(testMethod.getGroups()));
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            if (this.m_afterGroupsMap == null) {
                this.m_afterGroupsMap = this.initializeAfterGroupsMap();
            }
            return methodGroups.stream().filter(t2 -> this.isLastMethodForGroup((String)t2, testMethod)).map(t2 -> ConfigurationGroupMethods.retrieve(this.afterGroupsThatHaveAlreadyRun, this.m_afterGroupsMethods, t2)).filter(Objects::nonNull).flatMap(Collection::stream).filter(t2 -> this.isAfterGroupAllowedToRunAfterTestMethod((ITestNGMethod)t2, (Set<String>)methodGroups)).collect(Collectors.toList());
        }
    }

    private boolean isAfterGroupAllowedToRunAfterTestMethod(ITestNGMethod afterGroupMethod, Set<String> testMethodGroups) {
        String[] afterGroupMethodGroups = afterGroupMethod.getAfterGroups();
        if (afterGroupMethodGroups.length == 1 || testMethodGroups.containsAll(Arrays.asList(afterGroupMethodGroups))) {
            return true;
        }
        return Arrays.stream(afterGroupMethodGroups).allMatch(t2 -> testMethodGroups.contains(t2) || !CollectionUtils.hasElements((Collection)this.m_afterGroupsMap.get(t2)));
    }

    public void removeBeforeGroups(String[] groups) {
        for (String group : groups) {
            this.m_beforeGroupsMethods.remove(group);
            this.beforeGroupsThatHaveAlreadyRun.get(group).countDown();
        }
    }

    public void removeAfterGroups(Collection<String> groups) {
        for (String group : groups) {
            this.m_afterGroupsMethods.remove(group);
        }
    }

    private boolean isLastMethodForGroup(String group, ITestNGMethod method) {
        List<ITestNGMethod> methodsInGroup = this.m_afterGroupsMap.get(group);
        if (null == methodsInGroup || methodsInGroup.isEmpty()) {
            return true;
        }
        methodsInGroup.remove(method);
        return methodsInGroup.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map<String, List<ITestNGMethod>> result = Maps.newConcurrentMap();
        for (ITestNGMethod m4 : this.m_allMethods) {
            String[] groups;
            for (String g2 : groups = m4.getGroups()) {
                List methodsInGroup = result.computeIfAbsent(g2, key -> Lists.newArrayList());
                methodsInGroup.add(m4);
            }
        }
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            this.afterGroupsThatHaveAlreadyRun.clear();
        }
        return result;
    }

    private static List<ITestNGMethod> retrieve(Map<String, CountDownLatch> tracker, Map<String, List<ITestNGMethod>> map, String group) {
        if (tracker.containsKey(group)) {
            try {
                tracker.get(group).await();
            }
            catch (InterruptedException handled) {
                Logger.getLogger(ConfigurationGroupMethods.class).error(handled.getMessage(), handled);
                Thread.currentThread().interrupt();
            }
            return Collections.emptyList();
        }
        tracker.put(group, new CountDownLatch(1));
        return map.get(group);
    }

    private static List<ITestNGMethod> retrieve(Set<String> tracker, Map<String, List<ITestNGMethod>> map, String group) {
        if (tracker.contains(group)) {
            return Collections.emptyList();
        }
        tracker.add(group);
        return map.get(group);
    }
}

