/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.metadata.iso.quality.AbstractElement;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.quality.DefaultDomainConsistency;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.resources.Errors;
import org.opengis.feature.Attribute;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociation;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.Property;
import org.opengis.feature.PropertyType;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class Validator {
    final DefaultDataQuality quality = new DefaultDataQuality();

    Validator(ScopeCode scope) {
        if (scope != null) {
            this.quality.setScope(new DefaultScope(scope));
        }
    }

    private AbstractElement addViolationReport(AbstractElement report, PropertyType type, InternationalString explanation) {
        if (report == null) {
            GenericName name = type.getName();
            report = new DefaultDomainConsistency();
            report.setMeasureIdentification((Identifier)(name instanceof Identifier ? (Identifier)name : new NamedIdentifier(name)));
            report.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
            this.quality.getReports().add(report);
        }
        report.getResults().add(new DefaultConformanceResult(null, (CharSequence)explanation, false));
        return report;
    }

    private static Collection<?> asList(Object value, int maximumOccurrences) {
        if (maximumOccurrences <= 1) {
            return value != null ? Collections.singletonList(value) : Collections.emptyList();
        }
        return (Collection)value;
    }

    void validate(FeatureType type, Feature feature) {
        for (PropertyType pt : type.getProperties(true)) {
            DataQuality pq;
            Property property = feature.getProperty(pt.getName().toString());
            if (property instanceof AbstractAttribute) {
                pq = ((AbstractAttribute)property).quality();
            } else if (property instanceof AbstractAssociation) {
                pq = ((AbstractAssociation)property).quality();
            } else {
                if (property instanceof Attribute) {
                    this.validate(((Attribute)property).getType(), ((Attribute)property).getValues());
                    continue;
                }
                if (!(property instanceof FeatureAssociation)) continue;
                this.validate(((FeatureAssociation)property).getRole(), ((FeatureAssociation)property).getValues());
                continue;
            }
            if (pq == null) continue;
            this.quality.getReports().addAll(pq.getReports());
        }
    }

    void validateAny(PropertyType type, Object value) {
        if (type instanceof AttributeType) {
            this.validate((AttributeType)type, Validator.asList(value, ((AttributeType)type).getMaximumOccurs()));
        }
        if (type instanceof FeatureAssociationRole) {
            this.validate((FeatureAssociationRole)type, Validator.asList(value, ((FeatureAssociationRole)type).getMaximumOccurs()));
        }
    }

    void validate(AttributeType<?> type, Collection<?> values) {
        AbstractElement report = null;
        for (Object value : values) {
            Class valueClass = type.getValueClass();
            if (valueClass.isInstance(value)) continue;
            report = this.addViolationReport(report, (PropertyType)type, Errors.formatInternational((short)59, type.getName(), valueClass, value.getClass()));
            break;
        }
        this.verifyCardinality(report, (PropertyType)type, type.getMinimumOccurs(), type.getMaximumOccurs(), values.size());
    }

    void validate(FeatureAssociationRole role, Collection<?> values) {
        AbstractElement report = null;
        for (Object value : values) {
            FeatureType type = ((Feature)value).getType();
            FeatureType valueType = role.getValueType();
            if (valueType.isAssignableFrom(type)) continue;
            report = this.addViolationReport(report, (PropertyType)role, Errors.formatInternational((short)59, role.getName(), valueType.getName(), type.getName()));
            break;
        }
        this.verifyCardinality(report, (PropertyType)role, role.getMinimumOccurs(), role.getMaximumOccurs(), values.size());
    }

    private void verifyCardinality(AbstractElement report, PropertyType type, int minimumOccurs, int maximumOccurs, int count) {
        if (count < minimumOccurs) {
            InternationalString message = count == 0 ? Errors.formatInternational((short)89, (Object)type.getName()) : Errors.formatInternational((short)128, minimumOccurs, type.getName());
            this.addViolationReport(report, type, message);
        } else if (count > maximumOccurs) {
            InternationalString message = maximumOccurs == 0 ? Errors.formatInternational((short)41, (Object)type.getName()) : Errors.formatInternational((short)130, maximumOccurs, type.getName());
            this.addViolationReport(report, type, message);
        }
    }
}

