/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.math.FunctionProperty;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.feature.PropertyType;
import org.opengis.filter.Expression;
import org.opengis.filter.ValueReference;

final class AssociationValue<V>
extends LeafExpression<Feature, V>
implements ValueReference<Feature, V>,
Optimization.OnExpression<Feature, V> {
    private static final long serialVersionUID = 2082322712413854288L;
    private final String[] path;
    private final PropertyValue<V> accessor;

    AssociationValue(List<String> path, PropertyValue<V> accessor) {
        this.path = (String[])path.toArray(String[]::new);
        this.accessor = accessor;
    }

    private AssociationValue(String[] path, PropertyValue<V> accessor) {
        this.path = path;
        this.accessor = accessor;
    }

    public final Class<Feature> getResourceClass() {
        return Feature.class;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return AssociationValue.transitiveProperties(this.accessor.getParameters());
    }

    @Override
    protected final Collection<?> getChildren() {
        return Set.of(this.getXPath());
    }

    public final String getXPath() {
        StringJoiner sb = new StringJoiner("/", this.accessor.isVirtual ? "/*/" : "", "");
        for (String p : this.path) {
            sb.add(p);
        }
        return sb.add(this.accessor.name).toString();
    }

    public V apply(Feature instance) {
        block3: {
            if (instance != null) {
                for (String p : this.path) {
                    Object value = instance.getPropertyValue(p);
                    if (value instanceof Feature) {
                        instance = (Feature)value;
                        continue;
                    }
                    break block3;
                }
                return (V)this.accessor.apply(instance);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression<Feature, V> optimize(Optimization optimization) {
        block11: {
            FeatureType specifiedType = optimization.getFeatureType();
            if (specifiedType != null) {
                try {
                    Expression converted;
                    FeatureType type = specifiedType;
                    String[] direct = this.path;
                    for (int i = 0; i < this.path.length; ++i) {
                        PropertyType property = type.getProperty(this.path[i]);
                        Optional<String> link = Features.getLinkTarget(property);
                        if (link.isPresent()) {
                            if (direct == this.path) {
                                direct = (String[])direct.clone();
                            }
                            direct[i] = link.get();
                            property = type.getProperty(direct[i]);
                        }
                        if (property instanceof FeatureAssociationRole) {
                            type = ((FeatureAssociationRole)property).getValueType();
                            continue;
                        }
                        break block11;
                    }
                    optimization.setFeatureType(type);
                    try {
                        converted = this.accessor.optimize(optimization);
                    }
                    finally {
                        optimization.setFeatureType(specifiedType);
                    }
                    if (converted != this.accessor || direct != this.path) {
                        return new AssociationValue<V>(direct, converted);
                    }
                }
                catch (PropertyNotFoundException e) {
                    this.warning((Exception)((Object)e), true);
                }
            }
        }
        return this;
    }

    public final <N> Expression<Feature, N> toValueType(Class<N> target) {
        Expression converted = this.accessor.toValueType((Class)target);
        if (converted == this.accessor) {
            return this;
        }
        return new AssociationValue<V>(this.path, converted);
    }

    @Override
    public PropertyTypeBuilder expectedType(FeatureType valueType, FeatureTypeBuilder addTo) {
        for (String p : this.path) {
            PropertyType type;
            try {
                type = valueType.getProperty(p);
            }
            catch (PropertyNotFoundException e) {
                if (this.accessor.isVirtual) {
                    return this.accessor.expectedType(addTo);
                }
                throw e;
            }
            if (!(type instanceof FeatureAssociationRole)) {
                return null;
            }
            valueType = ((FeatureAssociationRole)type).getValueType();
        }
        return this.accessor.expectedType(valueType, addTo);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.path) + this.accessor.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AssociationValue) {
            AssociationValue other = (AssociationValue)obj;
            return Arrays.equals(this.path, other.path) && this.accessor.equals(other.accessor);
        }
        return false;
    }
}

