/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import javax.measure.Unit;
import org.apache.sis.coverage.BandedCoverage;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Static;

public final class SampleDimensions
extends Static {
    public static final ThreadLocal<SampleDimension[]> IMAGE_PROCESSOR_ARGUMENT = new ThreadLocal();

    private SampleDimensions() {
    }

    public static Unit<?>[] units(BandedCoverage source) {
        List<SampleDimension> bands = source.getSampleDimensions();
        Unit[] units = new Unit[bands.size()];
        for (int i = 0; i < units.length; ++i) {
            units[i] = bands.get(i).getUnits().orElse(null);
        }
        return units;
    }

    public static NumberRange<?>[] ranges(BandedCoverage source) {
        List<SampleDimension> bands = source.getSampleDimensions();
        NumberRange[] ranges = new NumberRange[bands.size()];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = bands.get(i).getSampleRange().orElse(null);
        }
        return ranges;
    }

    public static Number[] backgrounds(SampleDimension ... bands) {
        if (bands == null) {
            return null;
        }
        Number[] fillValues = new Number[bands.length];
        int i = fillValues.length;
        while (--i >= 0) {
            SampleDimension band = bands[i];
            Optional<Number> bg = band.getBackground();
            if (!bg.isPresent()) continue;
            fillValues[i] = bg.get();
        }
        return fillValues;
    }

    public static DoubleUnaryOperator[] toSampleFilters(SampleDimension ... bands) {
        if (bands == null) {
            return null;
        }
        DoubleUnaryOperator[] sampleFilters = new DoubleUnaryOperator[bands.length];
        for (int i = 0; i < sampleFilters.length; ++i) {
            SampleDimension band = bands[i];
            if (band == null) continue;
            List<Category> categories = band.getCategories();
            int count = categories.size();
            Number[] nodataValues = new Number[count + 1];
            for (int j = 0; j < count; ++j) {
                Number value;
                Category category = categories.get(j);
                if (category.isQuantitative()) continue;
                NumberRange<?> range = category.getSampleRange();
                if (range.isMinIncluded()) {
                    value = (Number)range.getMinValue();
                } else {
                    if (!range.isMaxIncluded()) continue;
                    value = (Number)range.getMaxValue();
                }
                nodataValues[j] = value;
            }
            nodataValues[count] = band.getBackground().orElse(null);
            sampleFilters[i] = ImageProcessor.filterNodataValues(nodataValues);
        }
        return sampleFilters;
    }
}

