/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.GeometryFactories;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public abstract class Geometries<G>
implements Serializable {
    private static final long serialVersionUID = 1856503921463395122L;
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.geometry");
    public static final int BIDIMENSIONAL = 2;
    public static final int TRIDIMENSIONAL = 3;
    public final GeometryLibrary library;
    public final transient Class<G> rootClass;
    public final transient Class<?> pointClass;
    public final transient Class<? extends G> polylineClass;
    public final transient Class<? extends G> polygonClass;
    transient Geometries<?> fallback;
    private final transient boolean isPointClassDistinct;

    protected Geometries(GeometryLibrary library, Class<G> rootClass, Class<?> pointClass, Class<? extends G> polylineClass, Class<? extends G> polygonClass) {
        this.library = library;
        this.rootClass = rootClass;
        this.pointClass = pointClass;
        this.polylineClass = polylineClass;
        this.polygonClass = polygonClass;
        this.isPointClassDistinct = !rootClass.isAssignableFrom(pointClass);
    }

    public static Geometries<?> implementation(GeometryLibrary library) {
        Geometries<?> g = GeometryFactories.implementation;
        if (library == null) {
            return g;
        }
        while (g != null) {
            if (g.library == library) {
                return g;
            }
            g = g.fallback;
        }
        throw new IllegalArgumentException(Resources.format((short)64, (Object)library));
    }

    public static Geometries<?> implementation(Class<?> type) {
        Geometries<?> g = GeometryFactories.implementation;
        while (g != null) {
            if (g.isSupportedType(type)) {
                return g;
            }
            g = g.fallback;
        }
        return null;
    }

    public static boolean isKnownType(Class<?> type) {
        Geometries<?> g = GeometryFactories.implementation;
        while (g != null) {
            if (g.isSupportedType(type)) {
                return true;
            }
            g = g.fallback;
        }
        return GeometryWrapper.class.isAssignableFrom(type);
    }

    private boolean isSupportedType(Class<?> type) {
        return this.rootClass.isAssignableFrom(type) || this.isPointClassDistinct && this.pointClass.isAssignableFrom(type);
    }

    public Class<?> getGeometryClass(GeometryType type) {
        switch (type) {
            default: {
                return this.rootClass;
            }
            case POINT: {
                return this.pointClass;
            }
            case LINESTRING: {
                return this.polylineClass;
            }
            case POLYGON: 
        }
        return this.polygonClass;
    }

    public static Optional<GeometryWrapper<?>> wrap(Object geometry) {
        if (geometry != null) {
            if (geometry instanceof GeometryWrapper) {
                return Optional.of((GeometryWrapper)geometry);
            }
            Geometries<?> g = GeometryFactories.implementation;
            while (g != null) {
                if (g.isSupportedType(geometry.getClass())) {
                    return Optional.of(g.castOrWrap(geometry));
                }
                g = g.fallback;
            }
        }
        return Optional.empty();
    }

    public abstract GeometryWrapper<G> castOrWrap(Object var1);

    protected static Object unwrap(Object geometry) {
        return geometry instanceof GeometryWrapper ? ((GeometryWrapper)geometry).implementation() : geometry;
    }

    public abstract GeometryWrapper<G> parseWKT(String var1) throws Exception;

    public abstract GeometryWrapper<G> parseWKB(ByteBuffer var1) throws Exception;

    public final GeometryWrapper<G> createPoint(DirectPosition point) {
        Object geometry;
        int n = point.getDimension();
        switch (n) {
            case 2: {
                geometry = this.createPoint(point.getOrdinate(0), point.getOrdinate(1));
                break;
            }
            case 3: {
                geometry = this.createPoint(point.getOrdinate(0), point.getOrdinate(1), point.getOrdinate(2));
                break;
            }
            default: {
                throw new MismatchedDimensionException(Errors.format((short)81, "point", n <= 2 ? 2 : 3, n));
            }
        }
        GeometryWrapper<G> wrapper = this.castOrWrap(geometry);
        if (point.getCoordinateReferenceSystem() != null) {
            wrapper.setCoordinateReferenceSystem(point.getCoordinateReferenceSystem());
        }
        return wrapper;
    }

    public boolean supportSinglePrecision() {
        return false;
    }

    public Object createPoint(float x, float y) {
        return this.createPoint((double)x, (double)y);
    }

    public abstract Object createPoint(double var1, double var3);

    public abstract Object createPoint(double var1, double var3, double var5);

    public abstract G createPolyline(boolean var1, int var2, Vector ... var3);

    public abstract GeometryWrapper<G> createMultiPolygon(Object[] var1);

    public abstract GeometryWrapper<G> createFromComponents(GeometryType var1, Object var2);

    private GeometryWrapper<G> createGeometry2D(Envelope envelope, int xd, int yd, boolean expand, boolean addPts) {
        double[] coordinates;
        CoordinateReferenceSystem crs;
        double ymax;
        double xmax;
        double ymin;
        double xmin;
        if (expand) {
            xmin = envelope.getMinimum(xd);
            ymin = envelope.getMinimum(yd);
            xmax = envelope.getMaximum(xd);
            ymax = envelope.getMaximum(yd);
        } else {
            DirectPosition lc = envelope.getLowerCorner();
            DirectPosition uc = envelope.getUpperCorner();
            xmin = lc.getOrdinate(xd);
            ymin = lc.getOrdinate(yd);
            xmax = uc.getOrdinate(xd);
            ymax = uc.getOrdinate(yd);
        }
        if (addPts && (crs = envelope.getCoordinateReferenceSystem()) != null) {
            boolean addYmax;
            boolean addXmax;
            boolean addYmin;
            int n = 10;
            CoordinateSystem cs = crs.getCoordinateSystem();
            CoordinateSystemAxis axis = cs.getAxis(xd);
            double xminIn = axis.getMinimumValue();
            double xmaxIn = axis.getMaximumValue();
            axis = cs.getAxis(yd);
            double yminIn = axis.getMinimumValue();
            double ymaxIn = axis.getMaximumValue();
            boolean addX = xmin <= xmax;
            boolean addY = ymin <= ymax;
            boolean addXmin = addX && xminIn > xmin;
            if (addXmin) {
                n += 4;
            }
            if (addYmin = addY && yminIn > ymin) {
                n += 4;
            }
            if (addXmax = addX && xmaxIn < xmax) {
                n += 4;
            }
            if (addYmax = addY && ymaxIn < ymax) {
                n += 4;
            }
            int i = 0;
            coordinates = new double[n];
            coordinates[i++] = xmin;
            coordinates[i++] = ymin;
            if (addYmin) {
                coordinates[i++] = xmin;
                coordinates[i++] = yminIn;
            }
            if (addYmax) {
                coordinates[i++] = xmin;
                coordinates[i++] = ymaxIn;
            }
            coordinates[i++] = xmin;
            coordinates[i++] = ymax;
            if (addXmin) {
                coordinates[i++] = xminIn;
                coordinates[i++] = ymax;
            }
            if (addXmax) {
                coordinates[i++] = xmaxIn;
                coordinates[i++] = ymax;
            }
            coordinates[i++] = xmax;
            coordinates[i++] = ymax;
            if (addYmax) {
                coordinates[i++] = xmax;
                coordinates[i++] = ymaxIn;
            }
            if (addYmin) {
                coordinates[i++] = xmax;
                coordinates[i++] = yminIn;
            }
            coordinates[i++] = xmax;
            coordinates[i++] = ymin;
            if (addXmax) {
                coordinates[i++] = xmaxIn;
                coordinates[i++] = ymin;
            }
            if (addXmin) {
                coordinates[i++] = xminIn;
                coordinates[i++] = ymin;
            }
            coordinates[i++] = xmin;
            coordinates[i++] = ymin;
            assert (i == n) : i;
        } else {
            coordinates = new double[]{xmin, ymin, xmin, ymax, xmax, ymax, xmax, ymin, xmin, ymin};
        }
        return this.createWrapper(this.createPolyline(true, 2, Vector.create(coordinates)));
    }

    public GeometryWrapper<G> toGeometry2D(Envelope envelope, WraparoundMethod strategy) {
        GeometryWrapper<G> result;
        int xd = 0;
        int yd = 1;
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        int dimension = envelope.getDimension();
        if (dimension != 2) {
            CoordinateSystem cs;
            CoordinateSystem csND;
            if (dimension < 2) {
                throw new IllegalArgumentException(Errors.format((short)31));
            }
            CoordinateReferenceSystem crsND = crs;
            if ((crs = CRS.getHorizontalComponent((CoordinateReferenceSystem)crsND)) == null) {
                crs = CRS.getComponentAt((CoordinateReferenceSystem)crsND, (int)0, (int)2);
            } else if (crs != crsND && (xd = AxisDirections.indexOfColinear((CoordinateSystem)(csND = crsND.getCoordinateSystem()), (AxisDirection)(cs = crs.getCoordinateSystem()).getAxis(0).getDirection())) == (yd = AxisDirections.indexOfColinear((CoordinateSystem)csND, (AxisDirection)cs.getAxis(1).getDirection()))) {
                ++yd;
            }
        }
        switch (strategy) {
            case NORMALIZE: {
                throw new IllegalArgumentException();
            }
            case NONE: {
                result = this.createGeometry2D(envelope, xd, yd, false, false);
                break;
            }
            default: {
                GeneralEnvelope ge = new GeneralEnvelope(envelope);
                ge.normalize();
                ge.wraparound(strategy);
                result = this.createGeometry2D((Envelope)ge, xd, yd, true, false);
                break;
            }
            case SPLIT: {
                Envelope[] parts = AbstractEnvelope.castOrCopy((Envelope)envelope).toSimpleEnvelopes();
                if (parts.length == 1) {
                    result = this.createGeometry2D(parts[0], xd, yd, true, false);
                    break;
                }
                Object[] polygons = new GeometryWrapper[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    polygons[i] = this.createGeometry2D(parts[i], xd, yd, true, false);
                    ((GeometryWrapper)polygons[i]).setCoordinateReferenceSystem(crs);
                }
                result = this.createMultiPolygon(polygons);
                break;
            }
        }
        result.setCoordinateReferenceSystem(crs);
        return result;
    }

    protected abstract GeometryWrapper<G> createWrapper(G var1);

    protected static String unsupported(String operation) {
        return Errors.format((short)162, operation);
    }

    protected static String unsupported(int dimension) {
        return Resources.format((short)76, dimension);
    }
}

