/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.j2d.PointWrapper;
import org.apache.sis.internal.feature.j2d.Wrapper;
import org.apache.sis.internal.referencing.j2d.AbstractShape;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.UnsupportedImplementationException;

public final class Factory
extends Geometries<Shape> {
    private static final long serialVersionUID = 2196319174347241786L;
    public static final Factory INSTANCE = new Factory();

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JAVA2D, Shape.class, Point2D.class, Shape.class, Shape.class);
    }

    @Override
    public GeometryWrapper<Shape> castOrWrap(Object geometry) {
        if (geometry == null || geometry instanceof Wrapper) {
            return (Wrapper)geometry;
        }
        if (geometry instanceof PointWrapper) {
            return (PointWrapper)geometry;
        }
        if (geometry instanceof Point2D) {
            return new PointWrapper((Point2D)geometry);
        }
        return new Wrapper((Shape)geometry);
    }

    @Override
    protected GeometryWrapper<Shape> createWrapper(Shape geometry) {
        return new Wrapper(geometry);
    }

    @Override
    public boolean supportSinglePrecision() {
        return true;
    }

    @Override
    public Object createPoint(float x, float y) {
        return new Point2D.Float(x, y);
    }

    @Override
    public Object createPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    @Override
    public Object createPoint(double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    private static Path2D createPath(boolean isFloat, int length) {
        return isFloat ? new Path2D.Float(1, length) : new Path2D.Double(1, length);
    }

    @Override
    public Shape createPolyline(boolean polygon, int dimension, Vector ... coordinates) {
        double y2;
        double x2;
        double y1;
        Vector v;
        double x1;
        if (dimension != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(dimension));
        }
        int length = 0;
        boolean isFloat = true;
        for (Vector v2 : coordinates) {
            if (v2 == null) continue;
            length = Math.addExact(length, v2.size());
            if (!isFloat) continue;
            isFloat = v2.isSinglePrecision();
        }
        if (!((length /= 2) != 2 || coordinates.length != 1 || Double.isNaN(x1 = (v = coordinates[0]).doubleValue(0)) || Double.isNaN(y1 = v.doubleValue(1)) || Double.isNaN(x2 = v.doubleValue(2)) || Double.isNaN(y2 = v.doubleValue(3)))) {
            Line2D path = isFloat ? new Line2D.Float() : new Line2D.Double();
            path.setLine(x1, y1, x2, y2);
            return path;
        }
        Path2D path = Factory.createPath(isFloat, length);
        boolean lineTo = false;
        for (Vector v3 : coordinates) {
            int size = v3.size();
            int i = 0;
            while (i < size) {
                double x = v3.doubleValue(i++);
                double y = v3.doubleValue(i++);
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    if (polygon) {
                        path.closePath();
                    }
                    lineTo = false;
                    continue;
                }
                if (lineTo) {
                    path.lineTo(x, y);
                    continue;
                }
                path.moveTo(x, y);
                lineTo = true;
            }
        }
        if (polygon) {
            path.closePath();
        }
        return ShapeUtilities.toPrimitive((Shape)path);
    }

    @Override
    public GeometryWrapper<Shape> createMultiPolygon(Object[] geometries) {
        if (geometries.length == 1) {
            return new Wrapper((Shape)Factory.unwrap(geometries[0]));
        }
        Shape[] shapes = new Shape[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            shapes[i] = (Shape)Factory.unwrap(geometries[i]);
        }
        boolean isFloat = true;
        for (Shape geometry : shapes) {
            if (AbstractShape.isFloat((Object)geometry)) continue;
            isFloat = false;
            break;
        }
        Path2D path = Factory.createPath(isFloat, 20);
        for (Shape geometry : shapes) {
            path.append(geometry, false);
        }
        path.trimToSize();
        return new Wrapper(path);
    }

    @Override
    public GeometryWrapper<Shape> createFromComponents(GeometryType type, Object components) {
        List<Object> data = components instanceof Collection ? (List<Object>)components : Arrays.asList((Object[])components);
        Shape geometry = (Shape)CollectionsExt.singletonOrNull(data);
        if (geometry == null) {
            Object component;
            boolean isFloat = true;
            Iterator iterator = data.iterator();
            while (iterator.hasNext() && (isFloat = AbstractShape.isFloat(component = iterator.next()))) {
            }
            Path2D path = Factory.createPath(isFloat, 20);
            if (type.isCollection()) {
                for (Object e : data) {
                    path.append((Shape)e, false);
                }
            } else {
                Iterator it = data.iterator();
                if (it.hasNext()) {
                    Point2D point2D = (Point2D)it.next();
                    path.moveTo(point2D.getX(), point2D.getY());
                    while (it.hasNext()) {
                        Point2D point2D2 = (Point2D)it.next();
                        path.lineTo(point2D2.getX(), point2D2.getY());
                    }
                    if (type == GeometryType.POLYGON) {
                        path.closePath();
                    }
                }
            }
            path.trimToSize();
            geometry = path;
        }
        return new Wrapper(geometry);
    }

    @Override
    public GeometryWrapper<Shape> parseWKT(String wkt) {
        throw new UnsupportedImplementationException(Factory.unsupported("parseWKT"));
    }

    @Override
    public GeometryWrapper<Shape> parseWKB(ByteBuffer data) {
        throw new UnsupportedImplementationException(Factory.unsupported("parseWKB"));
    }
}

