/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractJTSGeometryJ2D<T extends Geometry>
implements Shape,
Cloneable {
    static final Logger LOGGER = Logger.getLogger("org.geotoolkit.geometry");
    protected T geometry;
    protected final MathTransform transform;

    public AbstractJTSGeometryJ2D(T geom) {
        this(geom, null);
    }

    public AbstractJTSGeometryJ2D(T geom, MathTransform trs) {
        this.geometry = geom;
        this.transform = trs == null ? JTSGeometryIterator.IDENTITY : trs;
    }

    public void setGeometry(T g) {
        this.geometry = g;
    }

    public T getGeometry() {
        return this.geometry;
    }

    public MathTransform getTransform() {
        return this.transform;
    }

    protected MathTransform getInverse() {
        try {
            return this.transform.inverse();
        }
        catch (NoninvertibleTransformException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(Point2D p) {
        MathTransform inverse = this.getInverse();
        if (inverse != null) {
            double[] a = new double[]{p.getX(), p.getY()};
            this.safeTransform(inverse, a, a);
            Coordinate coord = new Coordinate(a[0], a[1]);
            Point point = ((Geometry)this.geometry).getFactory().createPoint(coord);
            return ((Geometry)this.geometry).contains(point);
        }
        return new GeneralPath(this).contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        return this.contains(p);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.intersectOrContains(x, y, w, h, false);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.geometry == null) {
            return null;
        }
        Envelope env = ((Geometry)this.geometry).getEnvelopeInternal();
        double[] p1 = new double[]{env.getMinX(), env.getMinY()};
        this.safeTransform(this.transform, p1, p1);
        double[] p2 = new double[]{env.getMaxX(), env.getMaxY()};
        this.safeTransform(this.transform, p2, p2);
        Rectangle2D.Double rect = new Rectangle2D.Double(p1[0], p1[1], 0.0, 0.0);
        rect.add(p2[0], p2[1]);
        return rect;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersectOrContains(x, y, w, h, true);
    }

    private boolean intersectOrContains(double x, double y, double w, double h, boolean intersect) {
        MathTransform inverse = this.getInverse();
        if (inverse != null) {
            double[] p1 = new double[]{x, y};
            this.safeTransform(inverse, p1, p1);
            double[] p2 = new double[]{x + w, y + h};
            this.safeTransform(inverse, p2, p2);
            Coordinate[] coords = new Coordinate[]{new Coordinate(p1[0], p1[1]), new Coordinate(p1[0], p2[1]), new Coordinate(p2[0], p2[1]), new Coordinate(p2[0], p1[1]), new Coordinate(p1[0], p1[1])};
            LinearRing lr = ((Geometry)this.geometry).getFactory().createLinearRing(coords);
            Polygon rect = ((Geometry)this.geometry).getFactory().createPolygon(lr, null);
            return intersect ? ((Geometry)this.geometry).intersects(rect) : ((Geometry)this.geometry).contains(rect);
        }
        GeneralPath path = new GeneralPath(this);
        return intersect ? path.intersects(x, y, w, h) : path.contains(x, y, w, h);
    }

    public AbstractJTSGeometryJ2D clone() {
        return null;
    }

    protected void safeTransform(MathTransform trs, double[] in, double[] out) {
        try {
            trs.transform(in, 0, out, 0, 1);
        }
        catch (TransformException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, Double.NaN);
        }
    }

    protected void safeTransform(double[] in, int offset, float[] out, int outOffset, int nb) {
        try {
            this.transform.transform(in, offset, out, outOffset, nb);
        }
        catch (TransformException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, outOffset, outOffset + nb * 2, Float.NaN);
        }
    }

    protected void safeTransform(double[] in, int offset, double[] out, int outOffset, int nb) {
        try {
            this.transform.transform(in, offset, out, outOffset, nb);
        }
        catch (TransformException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            Arrays.fill(out, outOffset, outOffset + nb * 2, Double.NaN);
        }
    }
}

