/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.geotoolkit.geometry.jts.awt.DecimateJTSGeomCollectionIterator;
import org.geotoolkit.geometry.jts.awt.DecimateJTSLineIterator;
import org.geotoolkit.geometry.jts.awt.JTSEmptyIterator;
import org.geotoolkit.geometry.jts.awt.JTSGeometryJ2D;
import org.geotoolkit.geometry.jts.awt.JTSPointIterator;
import org.geotoolkit.geometry.jts.awt.JTSPolygonIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;

public class DecimateJTSGeometryJ2D
extends JTSGeometryJ2D {
    private final double[] resolution;

    public DecimateJTSGeometryJ2D(Geometry geom, double[] resolution) {
        super(geom);
        this.resolution = resolution;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        AffineTransform2D t;
        AffineTransform2D affineTransform2D = t = at == null ? null : new AffineTransform2D(at);
        if (this.iterator == null) {
            if (this.geometry.isEmpty()) {
                this.iterator = JTSEmptyIterator.INSTANCE;
            } else if (this.geometry instanceof Point) {
                this.iterator = new JTSPointIterator((Point)this.geometry, (MathTransform)t);
            } else if (this.geometry instanceof Polygon) {
                this.iterator = new JTSPolygonIterator((Polygon)this.geometry, (MathTransform)t);
            } else if (this.geometry instanceof LineString) {
                this.iterator = new DecimateJTSLineIterator((LineString)this.geometry, (MathTransform)t, this.resolution);
            } else if (this.geometry instanceof GeometryCollection) {
                this.iterator = new DecimateJTSGeomCollectionIterator((GeometryCollection)this.geometry, (MathTransform)t, this.resolution);
            }
        } else {
            this.iterator.setTransform((MathTransform)t);
        }
        return this.iterator;
    }
}

