/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.distance;

import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class Utilities {
    static final double PI_4 = 0.7853981633974483;

    private Utilities() {
    }

    static boolean isLatLon(GeographicCRS in) throws IllegalArgumentException {
        EllipsoidalCS cs = in.getCoordinateSystem();
        for (int i = 0; i < cs.getDimension(); ++i) {
            AxisDirection axis = cs.getAxis(i).getDirection();
            if (AxisDirection.NORTH.equals(axis)) {
                return true;
            }
            if (AxisDirection.EAST.equals(axis)) {
                return false;
            }
            if (AxisDirection.SOUTH.equals(axis)) {
                return true;
            }
            if (!AxisDirection.WEST.equals(axis)) continue;
            return false;
        }
        throw new IllegalArgumentException("Given geographic CRS use neither north nor east axis directions.");
    }

    static Coordinate transform(Coordinate base, MathTransform tr, boolean flipAxes) {
        double[] coords = new double[]{base.x, base.y};
        try {
            tr.transform(coords, 0, coords, 0, 1);
        }
        catch (TransformException ex) {
            throw new RuntimeException(ex);
        }
        return flipAxes ? new Coordinate(coords[1], coords[0]) : new Coordinate(coords[0], coords[1]);
    }
}

