/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;

public class Vector2f
implements Vector {
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(float[] array) {
        this.x = array[0];
        this.y = array[1];
    }

    public int getDimension() {
        return 2;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = (float)value;
                break;
            }
            case 1: {
                this.y = (float)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = (float)values[0];
        this.y = (float)values[1];
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double lengthSquare() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public void normalize() {
        double s = 1.0 / this.length();
        this.x = (float)((double)this.x * s);
        this.y = (float)((double)this.y * s);
    }

    @Override
    public void add(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x + other.get(0));
        this.y = (float)((double)this.y + other.get(1));
    }

    @Override
    public void subtract(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x = (float)((double)this.x - other.get(0));
        this.y = (float)((double)this.y - other.get(1));
    }

    @Override
    public void scale(double scale) {
        this.x = (float)((double)this.x * scale);
        this.y = (float)((double)this.y * scale);
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{(int)this.x, (int)this.y};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{this.x, this.y};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x, this.y};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = (int)this.x;
        buffer[offset + 1] = (int)this.y;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

