/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
class GeographicRedimension
extends GeodeticOperation {
    private static final long serialVersionUID = -3021902514274756742L;

    GeographicRedimension(ParameterDescriptorGroup parameters, int sourceDimensions, int targetDimensions, GeodeticOperation[] redimensioned) {
        super(Conversion.class, parameters, CoordinateSystem.class, sourceDimensions, false, CoordinateSystem.class, targetDimensions, false, redimensioned);
    }

    GeographicRedimension(int dimension, GeodeticOperation[] redimensioned) {
        this(((ParameterBuilder)((ParameterBuilder)GeographicRedimension.builder().setCodeSpace(Citations.SIS, "SIS")).addName("Identity " + dimension + "D")).createGroup(new GeneralParameterDescriptor[0]), dimension, dimension, redimensioned);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return factory.createAffineTransform((Matrix)Matrices.createDiagonal(this.getTargetDimensions() + 1, this.getSourceDimensions() + 1));
    }
}

