/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.PoleRotation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class SouthPoleRotation
extends AbstractProvider {
    private static final long serialVersionUID = -5970630604222205521L;
    static final ParameterDescriptor<Double> POLE_LATITUDE;
    static final ParameterDescriptor<Double> POLE_LONGITUDE;
    static final ParameterDescriptor<Double> AXIS_ANGLE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public SouthPoleRotation() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, 2, false, EllipsoidalCS.class, 2, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup parameters) throws FactoryException {
        Parameters p = Parameters.castOrWrap(parameters);
        return PoleRotation.rotateSouthPole(factory, p.getValue(POLE_LATITUDE), p.getValue(POLE_LONGITUDE), p.getValue(AXIS_ANGLE));
    }

    static {
        ParameterBuilder builder = ((ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.NETCDF, "NetCDF")).setRequired(true);
        POLE_LATITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addName(Citations.SIS, "Latitude of rotated pole")).addName("grid_south_pole_latitude")).createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
        POLE_LONGITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addName(Citations.SIS, "Longitude of rotated pole")).addName("grid_south_pole_longitude")).createBounded(-180.0, 180.0, Double.NaN, Units.DEGREE);
        AXIS_ANGLE = ((ParameterBuilder)((ParameterBuilder)builder.setRequired(false).addName(Citations.SIS, "Axis rotation")).addName("grid_south_pole_angle")).createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.setRequired(true).addName(Citations.SIS, "South pole rotation")).addName(Citations.WMO, "Rotated Latitude/longitude")).addName("rotated_latlon_grib")).createGroup(new GeneralParameterDescriptor[]{POLE_LATITUDE, POLE_LONGITUDE, AXIS_ANGLE});
    }
}

