/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.GeographicOffsets;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class VerticalOffset
extends GeodeticOperation {
    private static final long serialVersionUID = -8309224700931038020L;
    private static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)VerticalOffset.builder().addIdentifier("9616")).addName("Vertical Offset")).createGroup(new GeneralParameterDescriptor[]{GeographicOffsets.TZ});

    public VerticalOffset() {
        super(Transformation.class, PARAMETERS, VerticalCS.class, 1, false, VerticalCS.class, 1, false, null);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException {
        Parameters pv = Parameters.castOrWrap(values);
        return MathTransforms.translation(pv.doubleValue(GeographicOffsets.TZ));
    }

    public static MathTransform postCreate(MathTransform parameterized, Matrix after) throws FactoryException {
        if (after.getElement(0, 0) < 0.0) {
            try {
                parameterized = parameterized.inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        return parameterized;
    }
}

