/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.GeodeticObjectParser;
import org.apache.sis.io.wkt.KeywordCase;
import org.apache.sis.io.wkt.KeywordStyle;
import org.apache.sis.io.wkt.SingletonElement;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;

public class WKTFormat
extends CompoundFormat<Object> {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.io.wkt");
    private static final long serialVersionUID = -2909110214650709560L;
    public static final int SINGLE_LINE = -1;
    private Symbols symbols;
    private Colors colors;
    private Convention convention = Convention.DEFAULT;
    private Citation authority;
    private KeywordCase keywordCase;
    private KeywordStyle keywordStyle;
    private Transliterator transliterator;
    private byte indentation;
    private int listSizeLimit;
    private transient Identifier defaultIdentifier;
    private TreeMap<String, StoredTree> fragments;
    private transient boolean isCloned;
    private transient Map<Object, Object> sharedValues;
    private transient Formatter formatter;
    private transient AbstractParser parser;
    private transient ReferencingFactoryContainer factories;
    private transient Warnings warnings;

    public WKTFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.symbols = Symbols.getDefault();
        this.keywordCase = KeywordCase.DEFAULT;
        this.keywordStyle = KeywordStyle.DEFAULT;
        this.indentation = (byte)2;
        this.listSizeLimit = Integer.MAX_VALUE;
    }

    private Map<String, StoredTree> fragments(boolean modifiable) {
        if (this.fragments == null) {
            if (!modifiable) {
                return Map.of();
            }
            this.fragments = new TreeMap();
            this.isCloned = false;
        } else if (this.isCloned & modifiable) {
            this.fragments = new TreeMap<String, StoredTree>((SortedMap<String, StoredTree>)this.fragments);
            this.isCloned = false;
        }
        return this.fragments;
    }

    private ReferencingFactoryContainer factories() {
        if (this.factories == null) {
            this.factories = new ReferencingFactoryContainer();
        }
        return this.factories;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.FORMAT) {
            return this.symbols.getLocale();
        }
        return super.getLocale(category);
    }

    final Locale getErrorLocale() {
        Locale locale = this.getLocale(Locale.Category.DISPLAY);
        return locale != null && locale != Locale.ROOT ? locale : Locale.getDefault(Locale.Category.DISPLAY);
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols.immutable();
            this.formatter = null;
            this.parser = null;
        }
    }

    public Transliterator getTransliterator() {
        Transliterator result = this.transliterator;
        if (result == null) {
            result = this.convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        }
        return result;
    }

    public void setTransliterator(Transliterator transliterator) {
        if (this.transliterator != transliterator) {
            this.transliterator = transliterator;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public KeywordCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(KeywordCase keywordCase) {
        ArgumentChecks.ensureNonNull("keywordCase", (Object)keywordCase);
        this.keywordCase = keywordCase;
        this.updateFormatter(this.formatter);
    }

    public KeywordStyle getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(KeywordStyle keywordStyle) {
        ArgumentChecks.ensureNonNull("keywordStyle", (Object)keywordStyle);
        this.keywordStyle = keywordStyle;
        this.updateFormatter(this.formatter);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        if (colors != null) {
            colors = colors.immutable();
        }
        this.colors = colors;
        this.updateFormatter(this.formatter);
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        if (this.convention != convention) {
            this.convention = convention;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public Citation getNameAuthority() {
        Citation result = this.authority;
        if (result == null) {
            result = this.convention.getNameAuthority();
        }
        return result;
    }

    public void setNameAuthority(Citation authority) {
        this.authority = authority;
        this.updateFormatter(this.formatter);
    }

    private void updateFormatter(Formatter formatter) {
        if (formatter != null) {
            byte longKeywords;
            byte toUpperCase;
            switch (this.keywordCase) {
                case LOWER_CASE: {
                    toUpperCase = -1;
                    break;
                }
                case UPPER_CASE: {
                    toUpperCase = 1;
                    break;
                }
                case CAMEL_CASE: {
                    toUpperCase = 0;
                    break;
                }
                default: {
                    toUpperCase = this.convention.toUpperCase ? (byte)1 : 0;
                }
            }
            switch (this.keywordStyle) {
                case SHORT: {
                    longKeywords = -1;
                    break;
                }
                case LONG: {
                    longKeywords = 1;
                    break;
                }
                default: {
                    longKeywords = this.convention.majorVersion() == 1 ? (byte)-1 : 0;
                }
            }
            formatter.configure(this.convention, this.authority, this.colors, toUpperCase, longKeywords, this.indentation, this.listSizeLimit);
            if (this.transliterator != null) {
                formatter.transliterator = this.transliterator;
            }
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        ArgumentChecks.ensureBetween("indentation", -1, 127, indentation);
        this.indentation = (byte)indentation;
        this.updateFormatter(this.formatter);
    }

    public int getMaximumListElements() {
        return this.listSizeLimit;
    }

    public void setMaximumListElements(int limit) {
        ArgumentChecks.ensureStrictlyPositive("limit", limit);
        this.listSizeLimit = limit;
        this.updateFormatter(this.formatter);
    }

    final void setDefaultIdentifier(Identifier identifier) {
        this.defaultIdentifier = identifier;
    }

    private void ensureValidFactoryType(Class<?> type) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("type", type);
        if (type != CRSFactory.class && type != CSFactory.class && type != DatumFactory.class && type != MathTransformFactory.class && type != CoordinateOperationFactory.class) {
            throw new IllegalArgumentException(this.errors().getString((short)45, "type", type));
        }
    }

    public <T extends Factory> T getFactory(Class<T> type) {
        this.ensureValidFactoryType(type);
        return this.factories().getFactory(type);
    }

    public <T extends Factory> void setFactory(Class<T> type, T factory) {
        this.ensureValidFactoryType(type);
        if (this.factories().setFactory(type, factory)) {
            this.parser = null;
        }
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    public Set<String> getFragmentNames() {
        return this.fragments(true).keySet();
    }

    public void addFragment(String name, String wkt) throws IllegalArgumentException, ParseException {
        ArgumentChecks.ensureNonEmpty("wkt", wkt);
        ArgumentChecks.ensureNonEmpty("name", name);
        if (!CharSequences.isUnicodeIdentifier(name)) {
            throw new IllegalArgumentException(this.errors().getString((short)112, name));
        }
        ParsePosition pos = new ParsePosition(0);
        StoredTree definition = this.textToTree(wkt, pos, name);
        int length = wkt.length();
        int index = CharSequences.skipLeadingWhitespaces(wkt, pos.getIndex(), length);
        if (index < length) {
            throw new UnparsableObjectException(this.getErrorLocale(), 135, new Object[]{name + " = " + definition.keyword() + "[\u2026]", CharSequences.token(wkt, index)}, index);
        }
        this.addFragment(name, definition);
        this.logWarnings(WKTFormat.class, "addFragment");
    }

    final void addFragment(String name, StoredTree definition) {
        if (this.fragments(true).putIfAbsent(name, definition) != null) {
            throw new IllegalArgumentException(this.errors().getString((short)27, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StoredTree textToTree(String wkt, ParsePosition pos, String aliasKey) throws ParseException {
        Object v0;
        AbstractParser parser = this.parser(true);
        ArrayList<Element> results = new ArrayList<Element>(4);
        this.warnings = null;
        try {
            while (true) {
                results.add(parser.textToTree(wkt, pos));
                if (aliasKey == null) break;
                int p = CharSequences.skipLeadingWhitespaces(wkt, pos.getIndex(), wkt.length());
                String separator = parser.symbols.trimmedSeparator();
                if (!wkt.startsWith(separator, p)) break;
                pos.setIndex(p + separator.length());
            }
            v0 = results.isEmpty() ? null : results.get(0);
        }
        catch (Throwable throwable) {
            this.warnings = parser.getAndClearWarnings(results.isEmpty() ? null : results.get(0));
            throw throwable;
        }
        this.warnings = parser.getAndClearWarnings(v0);
        if (this.sharedValues == null) {
            this.sharedValues = new HashMap<Object, Object>();
        }
        if (results.size() == 1) {
            return new StoredTree((Element)results.get(0), this.sharedValues);
        }
        return new StoredTree(results, this.sharedValues);
    }

    final void clear() {
        this.warnings = null;
        this.sharedValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(CharSequence wkt, ParsePosition pos) throws ParseException {
        this.clear();
        ArgumentChecks.ensureNonEmpty("wkt", wkt);
        ArgumentChecks.ensureNonNull("pos", pos);
        AbstractParser parser = this.parser(false);
        Object result = null;
        try {
            result = parser.createFromWKT(wkt.toString(), pos);
        }
        finally {
            this.warnings = parser.getAndClearWarnings(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object buildFromTree(StoredTree tree) throws ParseException {
        this.clear();
        AbstractParser parser = this.parser(false);
        parser.ignoredElements.clear();
        SingletonElement singleton = new SingletonElement();
        tree.toElements(parser, singleton, 0);
        Element root = new Element(singleton.value);
        Object result = null;
        try {
            result = parser.buildFromTree(root);
            root.close(parser.ignoredElements);
        }
        finally {
            this.warnings = parser.getAndClearWarnings(result);
        }
        return result;
    }

    private AbstractParser parser(boolean modifiable) {
        AbstractParser parser = this.parser;
        if (parser == null || this.isCloned & modifiable) {
            this.parser = parser = new Parser(this.symbols, this.fragments(modifiable), (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class), this.convention, this.transliterator != null ? this.transliterator : Transliterator.DEFAULT, this.getErrorLocale(), this.factories());
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(Object object, Appendable toAppendTo) throws IOException {
        this.clear();
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        StringBuffer buffer = toAppendTo instanceof StringBuffer ? (StringBuffer)toAppendTo : new StringBuffer(500);
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = new Formatter(this.getLocale(), this.getErrorLocale(), this.symbols, (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class));
            this.updateFormatter(formatter);
            this.formatter = formatter;
        }
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            boolean valid;
            try {
                formatter.setBuffer(buffer);
                valid = formatter.appendElement(object) || formatter.appendValue(object);
            }
            finally {
                this.warnings = formatter.getWarnings();
                formatter.setBuffer(null);
                formatter.clear();
            }
            if (this.warnings != null) {
                this.warnings.setRoot(object);
            }
            if (!valid) {
                throw new ClassCastException(this.errors().getString((short)42, "object", object.getClass()));
            }
            if (buffer != toAppendTo) {
                toAppendTo.append(buffer);
            }
        }
    }

    @Override
    protected Format createFormat(Class<?> valueType) {
        if (valueType == Number.class) {
            return this.symbols.createNumberFormat();
        }
        if (valueType == Date.class) {
            return new StandardDateFormat(this.symbols.getLocale(), this.getTimeZone());
        }
        Format format = super.createFormat(valueType);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    public Warnings getWarnings() {
        if (this.warnings != null) {
            this.warnings.publish();
        }
        return this.warnings;
    }

    final void logWarnings(Class<?> classe, String method) {
        if (this.warnings != null) {
            LogRecord record = new LogRecord(Level.WARNING, this.warnings.toString());
            Logging.completeAndLog(LOGGER, classe, method, record);
        }
    }

    final Errors errors() {
        return Errors.getResources(this.getErrorLocale());
    }

    @Override
    public WKTFormat clone() {
        WKTFormat clone = (WKTFormat)super.clone();
        clone.clear();
        clone.factories = null;
        clone.formatter = null;
        clone.parser = null;
        this.isCloned = true;
        clone.isCloned = true;
        return clone;
    }

    private final class Parser
    extends GeodeticObjectParser
    implements Function<Object, Object> {
        Parser(Symbols symbols, Map<String, StoredTree> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale errorLocale, ReferencingFactoryContainer factories) {
            super(symbols, fragments, numberFormat, dateFormat, unitFormat, convention, transliterator, errorLocale, factories);
        }

        @Override
        String getPublicFacade() {
            return WKTFormat.class.getName();
        }

        @Override
        String getFacadeMethod() {
            return "parse";
        }

        @Override
        public Object apply(Object key) {
            return new ImmutableIdentifier(WKTFormat.this.defaultIdentifier);
        }

        @Override
        void completeRoot(Map<String, Object> properties) {
            if (WKTFormat.this.defaultIdentifier != null) {
                properties.computeIfAbsent("identifiers", this);
            }
        }
    }
}

